/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordActionsGetFromCoordJobIdJPAExecutor
implements JPAExecutor<List<String>> {
    private String coordId;
    private int limit;
    private int offset;

    public CoordActionsGetFromCoordJobIdJPAExecutor(String coordId, int offset, int limit) {
        this.coordId = coordId;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "CoordActionsGetFromCoordJobIdJPAExecutor";
    }

    @Override
    public List<String> execute(EntityManager em) throws JPAExecutorException {
        List actions = null;
        try {
            Query jobQ = em.createNamedQuery("GET_COORD_ACTIONS_FOR_COORDINATOR");
            jobQ.setParameter("jobId", (Object)this.coordId);
            jobQ.setMaxResults(this.limit);
            jobQ.setFirstResult(this.offset);
            actions = jobQ.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return actions;
    }
}

