/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordActionsDeleteJPAExecutor
implements JPAExecutor<Integer> {
    private Collection<String> deleteList;

    public CoordActionsDeleteJPAExecutor(Collection<String> deleteList) {
        this.deleteList = deleteList;
    }

    public CoordActionsDeleteJPAExecutor() {
    }

    public void setDeleteList(Collection<String> deleteList) {
        this.deleteList = deleteList;
    }

    @Override
    public String getName() {
        return "CoordActionsDeleteJPAExecutor";
    }

    @Override
    public Integer execute(EntityManager em) throws JPAExecutorException {
        int actionsDeleted = 0;
        try {
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.deleteList != null && !this.deleteList.isEmpty()) {
                Query g = em.createNamedQuery("DELETE_ACTIONS_FOR_LONG_RUNNING_COORDINATOR");
                g.setParameter("actionId", this.deleteList);
                actionsDeleted = g.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return actionsDeleted;
    }
}

