/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency.hcat;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.dependency.hcat.HCatDependencyCache;
import org.apache.oozie.dependency.hcat.WaitingAction;
import org.apache.oozie.dependency.hcat.WaitingActions;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;

public class EhcacheHCatDependencyCache
implements HCatDependencyCache,
CacheEventListener {
    private static XLog LOG = XLog.getLog(EhcacheHCatDependencyCache.class);
    private static String TABLE_DELIMITER = "#";
    private static String PARTITION_DELIMITER = ";";
    public static String CONF_CACHE_NAME = "oozie.service.PartitionDependencyManagerService.cache.ehcache.name";
    private CacheManager cacheManager;
    private ConcurrentMap<String, Cache> missingDepsByServer;
    private CacheConfiguration cacheConfig;
    private ConcurrentMap<String, ConcurrentMap<String, SettableInteger>> partKeyPatterns;
    private ConcurrentMap<String, Collection<String>> availableDeps;

    @Override
    public void init(Configuration conf) {
        URL cacheConfigURL;
        String cacheName = conf.get(CONF_CACHE_NAME);
        if (cacheName == null) {
            cacheConfigURL = this.getClass().getClassLoader().getResource("ehcache-default.xml");
            cacheName = "dependency-default";
        } else {
            cacheConfigURL = this.getClass().getClassLoader().getResource("ehcache.xml");
        }
        if (cacheConfigURL == null) {
            throw new IllegalStateException("ehcache.xml is not found in classpath");
        }
        this.cacheManager = CacheManager.newInstance((URL)cacheConfigURL);
        Cache specifiedCache = this.cacheManager.getCache(cacheName);
        if (specifiedCache == null) {
            throw new IllegalStateException("Cache " + cacheName + " configured in " + CONF_CACHE_NAME + " is not found");
        }
        this.cacheConfig = specifiedCache.getCacheConfiguration();
        this.missingDepsByServer = new ConcurrentHashMap<String, Cache>();
        this.partKeyPatterns = new ConcurrentHashMap<String, ConcurrentMap<String, SettableInteger>>();
        this.availableDeps = new ConcurrentHashMap<String, Collection<String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMissingDependency(HCatURI hcatURI, String actionID) {
        Cache missingCache = (Cache)this.missingDepsByServer.get(hcatURI.getServer());
        if (missingCache == null) {
            CacheConfiguration clonedConfig = this.cacheConfig.clone();
            clonedConfig.setName(hcatURI.getServer());
            missingCache = new Cache(clonedConfig);
            Cache exists = this.missingDepsByServer.putIfAbsent(hcatURI.getServer(), missingCache);
            if (exists == null) {
                this.cacheManager.addCache(missingCache);
                missingCache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
            } else {
                missingCache.dispose();
            }
        }
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKeys = sortedPKV.getPartKeys();
        String missingKey = hcatURI.getDb() + TABLE_DELIMITER + hcatURI.getTable() + TABLE_DELIMITER + partKeys + TABLE_DELIMITER + sortedPKV.getPartVals();
        boolean newlyAdded = true;
        Cache cache = missingCache;
        synchronized (cache) {
            WaitingActions waitingActions;
            Element element = missingCache.get((Serializable)((Object)missingKey));
            if (element == null) {
                waitingActions = new WaitingActions();
                element = new Element((Serializable)((Object)missingKey), (Serializable)waitingActions);
                Element exists = missingCache.putIfAbsent(element);
                if (exists != null) {
                    newlyAdded = false;
                    waitingActions = (WaitingActions)exists.getObjectValue();
                }
                waitingActions.add(new WaitingAction(actionID, hcatURI.toURIString()));
            } else {
                newlyAdded = false;
                waitingActions = (WaitingActions)element.getObjectValue();
                waitingActions.add(new WaitingAction(actionID, hcatURI.toURIString()));
            }
        }
        if (newlyAdded) {
            String tableKey = hcatURI.getServer() + TABLE_DELIMITER + hcatURI.getDb() + TABLE_DELIMITER + hcatURI.getTable();
            ConcurrentMap<String, ConcurrentMap<String, SettableInteger>> concurrentMap = this.partKeyPatterns;
            synchronized (concurrentMap) {
                SettableInteger count;
                ConcurrentHashMap<String, SettableInteger> patternCounts = (ConcurrentHashMap<String, SettableInteger>)this.partKeyPatterns.get(tableKey);
                if (patternCounts == null) {
                    patternCounts = new ConcurrentHashMap<String, SettableInteger>();
                    this.partKeyPatterns.put(tableKey, patternCounts);
                }
                if ((count = (SettableInteger)patternCounts.get(partKeys)) == null) {
                    patternCounts.put(partKeys, new SettableInteger(1));
                } else {
                    count.increment();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMissingDependency(HCatURI hcatURI, String actionID) {
        Cache missingCache = (Cache)this.missingDepsByServer.get(hcatURI.getServer());
        if (missingCache == null) {
            LOG.warn("Remove missing dependency - Missing cache entry for server - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
            return false;
        }
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKeys = sortedPKV.getPartKeys();
        String missingKey = hcatURI.getDb() + TABLE_DELIMITER + hcatURI.getTable() + TABLE_DELIMITER + partKeys + TABLE_DELIMITER + sortedPKV.getPartVals();
        boolean decrement = false;
        boolean removed = false;
        Cache cache = missingCache;
        synchronized (cache) {
            Element element = missingCache.get((Serializable)((Object)missingKey));
            if (element == null) {
                LOG.warn("Remove missing dependency - Missing cache entry - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
                return false;
            }
            Collection<WaitingAction> waitingActions = ((WaitingActions)element.getObjectValue()).getWaitingActions();
            removed = waitingActions.remove(new WaitingAction(actionID, hcatURI.toURIString()));
            if (!removed) {
                LOG.warn("Remove missing dependency - Missing action ID - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
            }
            if (waitingActions.isEmpty()) {
                missingCache.remove((Serializable)((Object)missingKey));
                decrement = true;
            }
        }
        if (decrement) {
            String tableKey = hcatURI.getServer() + TABLE_DELIMITER + hcatURI.getDb() + TABLE_DELIMITER + hcatURI.getTable();
            this.decrementPartKeyPatternCount(tableKey, partKeys, hcatURI.toURIString());
        }
        return removed;
    }

    @Override
    public Collection<String> getWaitingActions(HCatURI hcatURI) {
        ArrayList<String> actionIDs = null;
        Cache missingCache = (Cache)this.missingDepsByServer.get(hcatURI.getServer());
        if (missingCache != null) {
            SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
            String missingKey = hcatURI.getDb() + TABLE_DELIMITER + hcatURI.getTable() + TABLE_DELIMITER + sortedPKV.getPartKeys() + TABLE_DELIMITER + sortedPKV.getPartVals();
            Element element = missingCache.get((Serializable)((Object)missingKey));
            if (element != null) {
                WaitingActions waitingActions = (WaitingActions)element.getObjectValue();
                actionIDs = new ArrayList<String>();
                String uriString = hcatURI.getURI().toString();
                for (WaitingAction action : waitingActions.getWaitingActions()) {
                    if (!action.getDependencyURI().equals(uriString)) continue;
                    actionIDs.add(action.getActionID());
                }
            }
        }
        return actionIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> markDependencyAvailable(String server, String db, String table, Map<String, String> partitions) {
        String tableKey = server + TABLE_DELIMITER + db + TABLE_DELIMITER + table;
        ConcurrentMap<String, ConcurrentMap<String, SettableInteger>> concurrentMap = this.partKeyPatterns;
        synchronized (concurrentMap) {
            Map patternCounts = (Map)this.partKeyPatterns.get(tableKey);
            if (patternCounts == null) {
                LOG.warn("Got partition available notification for " + tableKey + ". Unexpected as no matching partition keys. Unregistering topic");
                this.unregisterFromNotifications(server, db, table);
                return null;
            }
            Cache missingCache = (Cache)this.missingDepsByServer.get(server);
            if (missingCache == null) {
                LOG.warn("Got partition available notification for " + tableKey + ". Unexpected. Missing server entry in cache. Unregistering topic");
                this.partKeyPatterns.remove(tableKey);
                this.unregisterFromNotifications(server, db, table);
                return null;
            }
            HashSet<String> actionsWithAvailDep = new HashSet<String>();
            StringBuilder partValSB = new StringBuilder();
            for (Map.Entry entry : patternCounts.entrySet()) {
                String key2;
                String[] partKeys = ((String)entry.getKey()).split(PARTITION_DELIMITER);
                partValSB.setLength(0);
                for (String key2 : partKeys) {
                    partValSB.append(partitions.get(key2)).append(PARTITION_DELIMITER);
                }
                partValSB.setLength(partValSB.length() - 1);
                String missingKey = db + TABLE_DELIMITER + table + TABLE_DELIMITER + (String)entry.getKey() + TABLE_DELIMITER + partValSB.toString();
                boolean removed = false;
                Element element = null;
                key2 = missingCache;
                synchronized (key2) {
                    element = missingCache.get((Serializable)((Object)missingKey));
                    if (element != null) {
                        missingCache.remove((Serializable)((Object)missingKey));
                        removed = true;
                    }
                }
                if (!removed) continue;
                this.decrementPartKeyPatternCount(tableKey, (String)entry.getKey(), server + TABLE_DELIMITER + missingKey);
                Collection<WaitingAction> wActions = ((WaitingActions)element.getObjectValue()).getWaitingActions();
                for (WaitingAction wAction : wActions) {
                    Collection existing;
                    String actionID = wAction.getActionID();
                    actionsWithAvailDep.add(actionID);
                    Collection<String> depURIs = (ArrayList<String>)this.availableDeps.get(actionID);
                    if (depURIs == null && (existing = (Collection)this.availableDeps.putIfAbsent(actionID, depURIs = new ArrayList<String>())) != null) {
                        depURIs = existing;
                    }
                    ArrayList<String> arrayList = depURIs;
                    synchronized (arrayList) {
                        depURIs.add(wAction.getDependencyURI());
                        this.availableDeps.put(actionID, depURIs);
                    }
                }
            }
            return actionsWithAvailDep;
        }
    }

    @Override
    public Collection<String> getAvailableDependencyURIs(String actionID) {
        ArrayList available = (ArrayList)this.availableDeps.get(actionID);
        if (available != null) {
            available = new ArrayList(available);
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAvailableDependencyURIs(String actionID, Collection<String> dependencyURIs) {
        if (!this.availableDeps.containsKey(actionID)) {
            return false;
        }
        Collection availList = (Collection)this.availableDeps.get(actionID);
        if (!availList.removeAll(dependencyURIs)) {
            return false;
        }
        Collection collection = availList;
        synchronized (collection) {
            if (availList.isEmpty()) {
                this.availableDeps.remove(actionID);
            }
        }
        return true;
    }

    @Override
    public void destroy() {
        this.availableDeps.clear();
        this.cacheManager.shutdown();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void dispose() {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        String missingDepKey = (String)element.getObjectKey();
        LOG.info("Cache entry [{0}] of cache [{1}] expired", missingDepKey, cache.getName());
        this.onExpiryOrEviction(cache, element, missingDepKey);
    }

    public void notifyElementPut(Ehcache arg0, Element arg1) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache arg0, Element arg1) throws CacheException {
    }

    public void notifyElementUpdated(Ehcache arg0, Element arg1) throws CacheException {
    }

    public void notifyRemoveAll(Ehcache arg0) {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        String missingDepKey = (String)element.getObjectKey();
        LOG.info("Cache entry [{0}] of cache [{1}] evicted", missingDepKey, cache.getName());
        this.onExpiryOrEviction(cache, element, missingDepKey);
    }

    private void onExpiryOrEviction(Ehcache cache, Element element, String missingDepKey) {
        int partValIndex = missingDepKey.lastIndexOf(TABLE_DELIMITER);
        int partKeyIndex = missingDepKey.lastIndexOf(TABLE_DELIMITER, partValIndex - 1);
        String tableKey = cache.getName() + TABLE_DELIMITER + missingDepKey.substring(0, partKeyIndex);
        String partKeys = missingDepKey.substring(partKeyIndex + 1, partValIndex);
        this.decrementPartKeyPatternCount(tableKey, partKeys, missingDepKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPartKeyPatternCount(String tableKey, String partKeys, String hcatURI) {
        ConcurrentMap<String, ConcurrentMap<String, SettableInteger>> concurrentMap = this.partKeyPatterns;
        synchronized (concurrentMap) {
            Map patternCounts = (Map)this.partKeyPatterns.get(tableKey);
            if (patternCounts == null) {
                LOG.warn("Removed dependency - Missing cache entry - uri={0}. But no corresponding pattern key table entry", hcatURI);
            } else {
                SettableInteger count = (SettableInteger)patternCounts.get(partKeys);
                if (count == null) {
                    LOG.warn("Removed dependency - Missing cache entry - uri={0}. But no corresponding pattern key entry", hcatURI);
                } else {
                    count.decrement();
                    if (count.getValue() == 0) {
                        patternCounts.remove(partKeys);
                    }
                    if (patternCounts.isEmpty()) {
                        this.partKeyPatterns.remove(tableKey);
                        String[] tableDetails = tableKey.split(TABLE_DELIMITER);
                        this.unregisterFromNotifications(tableDetails[0], tableDetails[1], tableDetails[2]);
                    }
                }
            }
        }
    }

    private void unregisterFromNotifications(String server, String db, String table) {
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        hcatService.unregisterFromNotification(server, db, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNonWaitingCoordActions(Set<String> staleActions) {
        for (String server : this.missingDepsByServer.keySet()) {
            Cache missingCache = (Cache)this.missingDepsByServer.get(server);
            if (missingCache == null) continue;
            Cache cache = missingCache;
            synchronized (cache) {
                for (Object key : missingCache.getKeys()) {
                    Element element = missingCache.get(key);
                    if (element == null) continue;
                    Collection<WaitingAction> waitingActions = ((WaitingActions)element.getObjectValue()).getWaitingActions();
                    Iterator<WaitingAction> wactionItr = waitingActions.iterator();
                    HCatURI hcatURI = null;
                    while (wactionItr.hasNext()) {
                        WaitingAction waction = wactionItr.next();
                        if (!staleActions.contains(waction.getActionID())) continue;
                        try {
                            hcatURI = new HCatURI(waction.getDependencyURI());
                            wactionItr.remove();
                        }
                        catch (URISyntaxException e) {}
                    }
                    if (!waitingActions.isEmpty() || hcatURI == null) continue;
                    missingCache.remove(key);
                    SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
                    String partKeys = sortedPKV.getPartKeys();
                    String tableKey = hcatURI.getServer() + TABLE_DELIMITER + hcatURI.getDb() + TABLE_DELIMITER + hcatURI.getTable();
                    String hcatURIStr = hcatURI.toURIString();
                    this.decrementPartKeyPatternCount(tableKey, partKeys, hcatURIStr);
                }
            }
        }
    }

    @Override
    public void removeCoordActionWithDependenciesAvailable(String coordAction) {
    }

    private static class SettableInteger {
        private int value;

        public SettableInteger(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void increment() {
            ++this.value;
        }

        public void decrement() {
            --this.value;
        }
    }

    private static class SortedPKV {
        private StringBuilder partKeys = new StringBuilder();
        private StringBuilder partVals = new StringBuilder();

        public SortedPKV(Map<String, String> partitions) {
            ArrayList<String> keys = new ArrayList<String>(partitions.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.partKeys.append(key).append(PARTITION_DELIMITER);
                this.partVals.append(partitions.get(key)).append(PARTITION_DELIMITER);
            }
            this.partKeys.setLength(this.partKeys.length() - 1);
            this.partVals.setLength(this.partVals.length() - 1);
        }

        public String getPartKeys() {
            return this.partKeys.toString();
        }

        public String getPartVals() {
            return this.partVals.toString();
        }
    }
}

