/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.coord.input.dependency.AbstractCoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordInputInstance;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorPhaseOne;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorResult;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.ELEvaluator;

public class CoordInputLogicEvaluatorPhaseThree
extends CoordInputLogicEvaluatorPhaseOne {
    ELEvaluator eval;

    public CoordInputLogicEvaluatorPhaseThree(CoordinatorActionBean coordAction, ELEvaluator eval) {
        super(coordAction, (AbstractCoordInputDependency)coordAction.getPullInputDependencies());
        this.eval = eval;
    }

    @Override
    public CoordInputLogicEvaluatorResult evalInput(String dataSet, int min, int wait) {
        return this.getResultFromPullPush(this.coordAction, dataSet, min);
    }

    @Override
    public CoordInputLogicEvaluatorResult evalCombineInput(String[] inputSets, int min, int wait) {
        return this.combine(this.coordInputDependency, inputSets, min, wait);
    }

    @Override
    public CoordInputLogicEvaluatorResult combine(AbstractCoordInputDependency coordInputDependency, String[] inputSets, int min, int wait) {
        ArrayList<String> availableList = new ArrayList<String>();
        if (coordInputDependency.getDependencyMap().get(inputSets[0]) == null) {
            return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.FALSE);
        }
        try {
            String firstInputSet = inputSets[0];
            List<CoordInputInstance> firstInputSetList = coordInputDependency.getDependencyMap().get(firstInputSet);
            for (int i = 0; i < firstInputSetList.size(); ++i) {
                CoordInputInstance coordInputInstance = firstInputSetList.get(i);
                if (!coordInputInstance.isAvailable()) {
                    for (int j = 1; j < inputSets.length; ++j) {
                        if (!coordInputDependency.getDependencyMap().get(inputSets[j]).get(i).isAvailable()) continue;
                        availableList.add(this.getPathWithoutDoneFlag(coordInputDependency.getDependencyMap().get(inputSets[j]).get(i).getInputDataInstance(), inputSets[j]));
                    }
                    continue;
                }
                availableList.add(this.getPathWithoutDoneFlag(coordInputInstance.getInputDataInstance(), firstInputSet));
            }
        }
        catch (Exception e) {
            this.log.error(e);
            throw new RuntimeException(ErrorCode.E1028.format("Error executing combine function " + e.getMessage()));
        }
        boolean allFound = availableList.size() == coordInputDependency.getDependencyMap().get(inputSets[0]).size();
        return this.getEvalResult(allFound, min, wait, availableList);
    }

    @Override
    protected boolean pathExists(String sPath, Configuration actionConf) throws IOException, URISyntaxException, URIHandlerException {
        return false;
    }

    @Override
    public boolean isInputWaitElapsed(int timeInMin) {
        return true;
    }

    @Override
    public String getListAsString(List<String> input, String dataSet) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 1; i < input.size(); ++i) {
                sb.append(this.getPathWithoutDoneFlag(input.get(i - 1), dataSet)).append(",");
            }
            sb.append(this.getPathWithoutDoneFlag(input.get(input.size() - 1), dataSet));
        }
        catch (URIHandlerException e) {
            this.log.error(e);
            throw new RuntimeException(ErrorCode.E1028.format("Error finding path without done flag " + e.getMessage()));
        }
        return sb.toString();
    }

    private String getPathWithoutDoneFlag(String sPath, String dataSet) throws URIHandlerException {
        if (dataSet == null) {
            return sPath;
        }
        URIHandlerService service = Services.get().get(URIHandlerService.class);
        URIHandler handler = service.getURIHandler(sPath);
        return handler.getURIWithoutDoneFlag(sPath, this.eval.getVariable(".datain." + dataSet + ".doneFlag").toString());
    }
}

