/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.coord.input.dependency.AbstractCoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordInputInstance;
import org.apache.oozie.coord.input.dependency.CoordPullInputDependency;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluator;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorResult;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class CoordInputLogicEvaluatorPhaseOne
implements CoordInputLogicEvaluator {
    protected AbstractCoordInputDependency coordInputDependency;
    protected Map<String, List<CoordInputInstance>> dependencyMap;
    protected CoordinatorActionBean coordAction = null;
    protected XLog log = XLog.getLog(this.getClass());

    public CoordInputLogicEvaluatorPhaseOne(CoordinatorActionBean coordAction) {
        this(coordAction, coordAction.getPullInputDependencies());
    }

    public CoordInputLogicEvaluatorPhaseOne(CoordinatorActionBean coordAction, CoordInputDependency coordInputDependency) {
        this.coordAction = coordAction;
        this.coordInputDependency = (AbstractCoordInputDependency)coordInputDependency;
        this.dependencyMap = ((AbstractCoordInputDependency)coordInputDependency).getDependencyMap();
        LogUtils.setLogInfo(coordAction.getId());
    }

    @Override
    public CoordInputLogicEvaluatorResult evalInput(String dataSet, int min, int wait) {
        return this.input(this.coordInputDependency, dataSet, min, wait);
    }

    public CoordInputLogicEvaluatorResult input(AbstractCoordInputDependency coordInputDependency, String dataSet, int min, int wait) {
        ArrayList<String> availableList = new ArrayList<String>();
        if (coordInputDependency.getDependencyMap().get(dataSet) == null) {
            CoordInputLogicEvaluatorResult retData = new CoordInputLogicEvaluatorResult();
            if (((CoordPullInputDependency)this.coordAction.getPullInputDependencies()).getUnResolvedDependency(dataSet) == null) {
                return this.getResultFromPullPush(this.coordAction, dataSet, min);
            }
            this.log.debug("Data set [{0}] is unresolved set, will get resolved in phasetwo", dataSet);
            retData.setStatus(CoordInputLogicEvaluatorResult.STATUS.PHASE_TWO_EVALUATION);
            return retData;
        }
        boolean allFound = true;
        try {
            XConfiguration actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
            List<CoordInputInstance> firstInputSetList = coordInputDependency.getDependencyMap().get(dataSet);
            for (int i = 0; i < firstInputSetList.size(); ++i) {
                CoordInputInstance coordInputInstance = firstInputSetList.get(i);
                if (!coordInputInstance.isAvailable()) {
                    if (this.pathExists(coordInputInstance.getInputDataInstance(), actionConf)) {
                        availableList.add(coordInputInstance.getInputDataInstance());
                        coordInputDependency.addToAvailableDependencies(dataSet, coordInputInstance);
                        continue;
                    }
                    this.log.debug("[{0} is not found ", coordInputInstance.getInputDataInstance());
                    allFound = false;
                    if (min >= 0) continue;
                    break;
                }
                availableList.add(coordInputInstance.getInputDataInstance());
            }
        }
        catch (Exception e) {
            this.log.error(e);
            throw new RuntimeException(ErrorCode.E1028.format("Error executing input function " + e.getMessage()));
        }
        CoordInputLogicEvaluatorResult retData = this.getEvalResult(allFound, min, wait, availableList);
        this.log.debug("Resolved status of Data set [{0}] with min [{1}] and wait [{2}]  =  [{3}]", new Object[]{dataSet, min, wait, retData.getStatus()});
        return retData;
    }

    public boolean isInputWaitElapsed(int timeInMin) {
        if (timeInMin == -1) {
            return true;
        }
        long waitingTime = (new Date().getTime() - Math.max(this.coordAction.getNominalTime().getTime(), this.coordAction.getCreatedTime().getTime())) / 60000L;
        return (long)timeInMin <= waitingTime;
    }

    @Override
    public CoordInputLogicEvaluatorResult evalCombineInput(String[] inputSets, int min, int wait) {
        return this.combine(this.coordInputDependency, inputSets, min, wait);
    }

    public CoordInputLogicEvaluatorResult combine(AbstractCoordInputDependency coordInputDependency, String[] inputSets, int min, int wait) {
        ArrayList<String> availableList = new ArrayList<String>();
        if (coordInputDependency.getDependencyMap().get(inputSets[0]) == null) {
            return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.TIMED_WAITING);
        }
        try {
            XConfiguration jobConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
            String firstInputSet = inputSets[0];
            List<CoordInputInstance> firstInputSetList = coordInputDependency.getDependencyMap().get(firstInputSet);
            for (int i = 0; i < firstInputSetList.size(); ++i) {
                CoordInputInstance coordInputInstance = firstInputSetList.get(i);
                boolean found = false;
                if (!coordInputInstance.isAvailable()) {
                    if (!this.pathExists(coordInputInstance.getInputDataInstance(), jobConf)) {
                        this.log.debug(MessageFormat.format("{0} is not found. Looking from other datasets.", coordInputInstance.getInputDataInstance()));
                        for (int j = 1; j < inputSets.length; ++j) {
                            if (!coordInputDependency.getDependencyMap().get(inputSets[j]).get(i).isAvailable()) {
                                if (!this.pathExists(coordInputDependency.getDependencyMap().get(inputSets[j]).get(i).getInputDataInstance(), jobConf)) continue;
                                coordInputDependency.addToAvailableDependencies(inputSets[j], coordInputDependency.getDependencyMap().get(inputSets[j]).get(i));
                                availableList.add(coordInputDependency.getDependencyMap().get(inputSets[j]).get(i).getInputDataInstance());
                                this.log.debug(MessageFormat.format("{0} is found.", coordInputInstance.getInputDataInstance()));
                                found = true;
                                continue;
                            }
                            coordInputDependency.addToAvailableDependencies(inputSets[j], coordInputDependency.getDependencyMap().get(inputSets[j]).get(i));
                            availableList.add(coordInputDependency.getDependencyMap().get(inputSets[j]).get(i).getInputDataInstance());
                            found = true;
                        }
                    } else {
                        coordInputDependency.addToAvailableDependencies(firstInputSet, coordInputInstance);
                        availableList.add(coordInputInstance.getInputDataInstance());
                        found = true;
                    }
                } else {
                    availableList.add(coordInputInstance.getInputDataInstance());
                    found = true;
                }
                if (min >= 0 || found) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error(e);
            throw new RuntimeException(ErrorCode.E1028.format("Error executing combine function " + e.getMessage()));
        }
        boolean allFound = availableList.size() == coordInputDependency.getDependencyMap().get(inputSets[0]).size();
        CoordInputLogicEvaluatorResult retData = this.getEvalResult(allFound, min, wait, availableList);
        this.log.debug("Resolved status of Data set [{0}] with min [{1}] and wait [{2}]  =  [{3}]", new Object[]{Arrays.toString(inputSets), min, wait, retData.getStatus()});
        return retData;
    }

    public Configuration getConf() throws IOException {
        return new XConfiguration(new StringReader(this.coordAction.getRunConf()));
    }

    public String getListAsString(List<String> list, String dataset) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < list.size(); ++i) {
            sb.append(list.get(i - 1)).append(",");
        }
        sb.append(list.get(list.size() - 1));
        return sb.toString();
    }

    protected CoordInputLogicEvaluatorResult getEvalResult(boolean found, int min, int wait, List<String> availableList) {
        CoordInputLogicEvaluatorResult retData = new CoordInputLogicEvaluatorResult();
        if (!found && wait > 0 && !this.isInputWaitElapsed(wait)) {
            return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.TIMED_WAITING);
        }
        if (found || min > 0 && availableList.size() >= min) {
            retData.setStatus(CoordInputLogicEvaluatorResult.STATUS.TRUE);
            retData.setDataSets(this.getListAsString(availableList, null));
        }
        if (min == 0) {
            retData.setStatus(CoordInputLogicEvaluatorResult.STATUS.TRUE);
        }
        return retData;
    }

    protected boolean pathExists(String sPath, Configuration jobConf) throws IOException, URISyntaxException, URIHandlerException {
        return CoordCommandUtils.pathExists(sPath, jobConf);
    }

    public CoordInputLogicEvaluatorResult getResultFromPullPush(CoordinatorActionBean coordAction, String dataSet, int min) {
        CoordInputLogicEvaluatorResult result = new CoordInputLogicEvaluatorResult();
        CoordInputLogicEvaluatorResult pullResult = this.getEvalResult((AbstractCoordInputDependency)coordAction.getPullInputDependencies(), dataSet, min);
        CoordInputLogicEvaluatorResult pushResult = this.getEvalResult((AbstractCoordInputDependency)coordAction.getPushInputDependencies(), dataSet, min);
        result.appendDataSets(pullResult.getDataSets());
        result.appendDataSets(pushResult.getDataSets());
        if (pullResult.isWaiting() || pushResult.isWaiting()) {
            result.setStatus(CoordInputLogicEvaluatorResult.STATUS.TIMED_WAITING);
        } else if (pullResult.isPhaseTwoEvaluation() || pushResult.isPhaseTwoEvaluation()) {
            result.setStatus(CoordInputLogicEvaluatorResult.STATUS.PHASE_TWO_EVALUATION);
        } else if (pullResult.isTrue() || pushResult.isTrue()) {
            result.setStatus(CoordInputLogicEvaluatorResult.STATUS.TRUE);
        } else {
            result.setStatus(CoordInputLogicEvaluatorResult.STATUS.FALSE);
        }
        return result;
    }

    public CoordInputLogicEvaluatorResult getEvalResult(AbstractCoordInputDependency coordInputDependencies, String dataSet, int min) {
        CoordInputLogicEvaluatorResult result = new CoordInputLogicEvaluatorResult();
        if (coordInputDependencies.getAvailableDependencies(dataSet) == null || coordInputDependencies.getAvailableDependencies(dataSet).isEmpty()) {
            if (min == 0) {
                result.setStatus(CoordInputLogicEvaluatorResult.STATUS.TRUE);
            } else {
                result.setStatus(CoordInputLogicEvaluatorResult.STATUS.FALSE);
            }
        }
        if (min > -1 && coordInputDependencies.getAvailableDependencies(dataSet).size() >= min) {
            result.setStatus(CoordInputLogicEvaluatorResult.STATUS.TRUE);
            result.appendDataSets(this.getListAsString(coordInputDependencies.getAvailableDependencies(dataSet), dataSet));
        } else if (coordInputDependencies.isDataSetResolved(dataSet)) {
            result.setStatus(CoordInputLogicEvaluatorResult.STATUS.TRUE);
            result.appendDataSets(this.getListAsString(coordInputDependencies.getAvailableDependencies(dataSet), dataSet));
        }
        return result;
    }
}

