/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.dependency;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.coord.input.dependency.CoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordInputDependencyFactory;
import org.apache.oozie.coord.input.dependency.CoordInputInstance;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorUtil;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractCoordInputDependency
implements Writable,
CoordInputDependency {
    protected boolean isDependencyMet = false;
    protected transient Map<String, List<String>> missingDependenciesSet = new HashMap<String, List<String>>();
    protected transient Map<String, List<String>> availableDependenciesSet = new HashMap<String, List<String>>();
    protected Map<String, List<CoordInputInstance>> dependencyMap = new HashMap<String, List<CoordInputInstance>>();

    public AbstractCoordInputDependency() {
    }

    public AbstractCoordInputDependency(Map<String, List<CoordInputInstance>> dependencyMap) {
        this.dependencyMap = dependencyMap;
        this.generateDependencies();
    }

    @Override
    public void addInputInstanceList(String inputEventName, List<CoordInputInstance> inputInstanceList) {
        this.dependencyMap.put(inputEventName, inputInstanceList);
    }

    public Map<String, List<CoordInputInstance>> getDependencyMap() {
        return this.dependencyMap;
    }

    public void setDependencyMap(Map<String, List<CoordInputInstance>> dependencyMap) {
        this.dependencyMap = dependencyMap;
    }

    public void addToAvailableDependencies(String dataSet, CoordInputInstance coordInputInstance) {
        coordInputInstance.setAvailability(true);
        List<String> availableSet = this.availableDependenciesSet.get(dataSet);
        if (availableSet == null) {
            availableSet = new ArrayList<String>();
            this.availableDependenciesSet.put(dataSet, availableSet);
        }
        availableSet.add(coordInputInstance.getInputDataInstance());
        this.removeFromMissingDependencies(dataSet, coordInputInstance);
    }

    public void removeFromMissingDependencies(String dataSet, CoordInputInstance coordInputInstance) {
        coordInputInstance.setAvailability(true);
        List<String> missingSet = this.missingDependenciesSet.get(dataSet);
        if (missingSet != null) {
            missingSet.remove(coordInputInstance.getInputDataInstance());
            if (missingSet.isEmpty()) {
                this.missingDependenciesSet.remove(dataSet);
            }
        }
    }

    public void addToMissingDependencies(String dataSet, CoordInputInstance coordInputInstance) {
        List<String> availableSet = this.missingDependenciesSet.get(dataSet);
        if (availableSet == null) {
            availableSet = new ArrayList<String>();
        }
        availableSet.add(coordInputInstance.getInputDataInstance());
        this.missingDependenciesSet.put(dataSet, availableSet);
    }

    protected void generateDependencies() {
        try {
            this.missingDependenciesSet = new HashMap<String, List<String>>();
            this.availableDependenciesSet = new HashMap<String, List<String>>();
            Set<String> keySets = this.dependencyMap.keySet();
            for (String key : keySets) {
                for (CoordInputInstance coordInputInstance : this.dependencyMap.get(key)) {
                    if (coordInputInstance.isAvailable()) {
                        this.addToAvailableDependencies(key, coordInputInstance);
                        continue;
                    }
                    this.addToMissingDependencies(key, coordInputInstance);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getAvailableDependencies(String dataSet) {
        if (this.availableDependenciesSet.get(dataSet) != null) {
            return this.availableDependenciesSet.get(dataSet);
        }
        return new ArrayList<String>();
    }

    public String getMissingDependencies(String dataSet) {
        StringBuilder sb = new StringBuilder();
        for (String dependencies : this.missingDependenciesSet.get(dataSet)) {
            sb.append(dependencies).append("#");
        }
        return sb.toString();
    }

    public void addToAvailableDependencies(String dataSet, String availableSet) {
        List<CoordInputInstance> list = this.dependencyMap.get(dataSet);
        if (list == null) {
            list = new ArrayList<CoordInputInstance>();
            this.dependencyMap.put(dataSet, list);
        }
        for (String available : availableSet.split("#")) {
            CoordInputInstance coordInstance = new CoordInputInstance(available, true);
            list.add(coordInstance);
            this.addToAvailableDependencies(dataSet, coordInstance);
        }
    }

    @Override
    public String getMissingDependencies() {
        StringBuilder sb = new StringBuilder();
        if (this.missingDependenciesSet != null) {
            for (List<String> dependenciesList : this.missingDependenciesSet.values()) {
                for (String dependencies : dependenciesList) {
                    sb.append(dependencies).append("#");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public List<String> getMissingDependenciesAsList() {
        ArrayList<String> missingDependencies = new ArrayList<String>();
        for (List<String> dependenciesList : this.missingDependenciesSet.values()) {
            missingDependencies.addAll(dependenciesList);
        }
        return missingDependencies;
    }

    @Override
    public List<String> getAvailableDependenciesAsList() {
        ArrayList<String> availableDependencies = new ArrayList<String>();
        for (List<String> dependenciesList : this.availableDependenciesSet.values()) {
            availableDependencies.addAll(dependenciesList);
        }
        return availableDependencies;
    }

    @Override
    public String serialize() throws IOException {
        return CoordInputDependencyFactory.getMagicNumber() + new String(WritableUtils.toByteArray(this), "ISO-8859-1");
    }

    public String getListAsString(List<String> dataSets) {
        StringBuilder sb = new StringBuilder();
        for (String dependencies : dataSets) {
            sb.append(dependencies).append("#");
        }
        return sb.toString();
    }

    @Override
    public void setDependencyMet(boolean isDependencyMeet) {
        this.isDependencyMet = isDependencyMeet;
    }

    @Override
    public boolean isDependencyMet() {
        return this.missingDependenciesSet.isEmpty() || this.isDependencyMet;
    }

    @Override
    public boolean isUnResolvedDependencyMet() {
        return false;
    }

    @Override
    public void addToAvailableDependencies(Collection<String> availableList) {
        for (Map.Entry<String, List<CoordInputInstance>> dependenciesList : this.dependencyMap.entrySet()) {
            for (CoordInputInstance coordInputInstance : dependenciesList.getValue()) {
                if (!availableList.contains(coordInputInstance.getInputDataInstance())) continue;
                this.addToAvailableDependencies(dependenciesList.getKey(), coordInputInstance);
            }
        }
    }

    @Override
    public ActionDependency checkPushMissingDependencies(CoordinatorActionBean coordAction, boolean registerForNotification) throws CommandException, IOException, JDOMException {
        boolean status = new CoordInputLogicEvaluatorUtil(coordAction).checkPushDependencies();
        if (status) {
            coordAction.getPushInputDependencies().setDependencyMet(true);
        }
        return new ActionDependency(coordAction.getPushInputDependencies().getMissingDependenciesAsList(), coordAction.getPushInputDependencies().getAvailableDependenciesAsList());
    }

    @Override
    public boolean checkPullMissingDependencies(CoordinatorActionBean coordAction, StringBuilder existList, StringBuilder nonExistList) throws IOException, JDOMException {
        boolean status = new CoordInputLogicEvaluatorUtil(coordAction).checkPullMissingDependencies();
        if (status) {
            coordAction.getPullInputDependencies().setDependencyMet(true);
        }
        return status;
    }

    @Override
    public boolean isChangeInDependency(StringBuilder nonExistList, String missingDependencies, StringBuilder nonResolvedList, boolean status) {
        if (!StringUtils.isEmpty((String)missingDependencies)) {
            return !missingDependencies.equals(this.getMissingDependencies());
        }
        return true;
    }

    @Override
    public boolean checkUnresolved(CoordinatorActionBean coordAction, Element eAction) throws Exception {
        String actualTimeStr = eAction.getAttributeValue("action-actual-time");
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        Date actualTime = null;
        actualTime = actualTimeStr == null ? new Date() : DateUtils.parseDateOozieTZ(actualTimeStr);
        if (inputList == null) {
            return true;
        }
        List eDataEvents = inputList.getChildren("data-in", eAction.getNamespace());
        for (Element dEvent : eDataEvents) {
            if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
            String unResolvedInstance = dEvent.getChild("unresolved-instances", dEvent.getNamespace()).getTextTrim();
            String name = dEvent.getAttribute("name").getValue();
            this.addUnResolvedList(name, unResolvedInstance);
        }
        return new CoordInputLogicEvaluatorUtil(coordAction).checkUnResolved(actualTime);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeStringAsBytes(out, "V=1");
        out.writeBoolean(this.isDependencyMet);
        WritableUtils.writeMapWithList(out, this.dependencyMap);
    }

    public void readFields(DataInput in) throws IOException {
        WritableUtils.readBytesAsString(in);
        this.isDependencyMet = in.readBoolean();
        this.dependencyMap = WritableUtils.readMapWithList(in, CoordInputInstance.class);
        this.generateDependencies();
    }

    public boolean isDataSetResolved(String dataSet) {
        if (this.getAvailableDependencies(dataSet) == null || this.getDependencyMap().get(dataSet) == null) {
            return false;
        }
        return this.getAvailableDependencies(dataSet).size() == this.getDependencyMap().get(dataSet).size();
    }
}

