/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetActionsJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class ResumeXCommand
extends WorkflowXCommand<Void> {
    private String id;
    private JPAService jpaService = null;
    private WorkflowJobBean workflow = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();

    public ResumeXCommand(String id) {
        super("resume", "resume", 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.id);
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            WorkflowInstance wfInstance;
            if (this.workflow.getStatus() == WorkflowJob.Status.SUSPENDED) {
                InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
                this.workflow.getWorkflowInstance().resume();
                wfInstance = this.workflow.getWorkflowInstance();
                ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.RUNNING);
                this.workflow.setWorkflowInstance(wfInstance);
                this.workflow.setStatus(WorkflowJob.Status.RUNNING);
                for (WorkflowActionBean action : this.jpaService.execute(new WorkflowJobGetActionsJPAExecutor(this.id))) {
                    Date nextRunTime;
                    if (action.isRetryOrManual()) {
                        action.setPendingOnly();
                        this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, action));
                    }
                    if (!action.isPending()) continue;
                    if (action.getStatus() == WorkflowAction.Status.PREP || action.getStatus() == WorkflowAction.Status.START_MANUAL) {
                        ActionXCommand.ActionExecutorContext context;
                        if (!(action.getType().equals(":START:") || action.getType().equals(":FORK:") || action.getType().equals(":JOIN:") || action.getType().equals(":KILL:") || action.getType().equals(":END:") || !(context = new ActionXCommand.ActionExecutorContext(this.workflow, action, false, false)).getAppFileSystem().exists(context.getActionDir()))) {
                            context.getAppFileSystem().delete(context.getActionDir(), true);
                        }
                        this.queue(new ActionStartXCommand(action.getId(), action.getType()));
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.START_RETRY) {
                        nextRunTime = action.getPendingAge();
                        this.queue(new ActionStartXCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.DONE || action.getStatus() == WorkflowAction.Status.END_MANUAL) {
                        this.queue(new ActionEndXCommand(action.getId(), action.getType()));
                        continue;
                    }
                    if (action.getStatus() != WorkflowAction.Status.END_RETRY) continue;
                    nextRunTime = action.getPendingAge();
                    this.queue(new ActionEndXCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                }
                this.workflow.setLastModifiedTime(new Date());
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.workflow));
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
                if (EventHandlerService.isEnabled()) {
                    ResumeXCommand.generateEvent(this.workflow);
                }
                this.queue(new WorkflowNotificationXCommand(this.workflow));
            }
            wfInstance = null;
            return wfInstance;
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        catch (HadoopAccessorException e) {
            throw new CommandException(e);
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E0902, e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new CommandException(ErrorCode.E0902, e.getMessage(), e);
        }
        finally {
            this.updateParentIfNecessary(this.workflow);
        }
    }

    @Override
    public String getEntityKey() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.id;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.workflow = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_RESUME, this.id);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.workflow);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.workflow.getStatus() != WorkflowJob.Status.SUSPENDED) {
            throw new PreconditionException(ErrorCode.E1100, "workflow's status is " + this.workflow.getStatusStr() + " is not SUSPENDED");
        }
    }
}

