/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowIdGetForExternalIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class ExternalIdXCommand
extends WorkflowXCommand<String> {
    private String externalId;

    public ExternalIdXCommand(String externalId) {
        super("externalId", "externalId", 1);
        this.externalId = ParamChecker.notEmpty(externalId, "externalId");
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return this.externalId;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected String execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            String wfId = null;
            if (jpaService != null) {
                wfId = jpaService.execute(new WorkflowIdGetForExternalIdJPAExecutor(this.externalId));
            } else {
                this.LOG.error((Object)ErrorCode.E0610);
            }
            return wfId;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }
}

