/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.List;
import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowsJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BulkWorkflowXCommand
extends WorkflowXCommand<WorkflowsInfo> {
    private final Map<String, List<String>> filter;
    private final int start;
    private final int len;
    private WorkflowsInfo workflowsInfo;
    private OperationType operation;

    public BulkWorkflowXCommand(Map<String, List<String>> filter, int start, int length, OperationType operation) {
        super("bulkkill", "bulkkill", 1, true);
        this.filter = filter;
        this.start = start;
        this.len = length;
        this.operation = operation;
    }

    @Override
    protected WorkflowsInfo execute() throws CommandException {
        try {
            List<WorkflowJobBean> workflows = this.workflowsInfo.getWorkflows();
            block7: for (WorkflowJobBean job : workflows) {
                switch (this.operation) {
                    case Kill: {
                        if (job.getStatus() != WorkflowJob.Status.PREP && job.getStatus() != WorkflowJob.Status.RUNNING && job.getStatus() != WorkflowJob.Status.SUSPENDED && job.getStatus() != WorkflowJob.Status.FAILED) continue block7;
                        new KillXCommand(job.getId()).call();
                        continue block7;
                    }
                    case Suspend: {
                        if (job.getStatus() != WorkflowJob.Status.RUNNING) continue block7;
                        new SuspendXCommand(job.getId()).call();
                        continue block7;
                    }
                    case Resume: {
                        if (job.getStatus() != WorkflowJob.Status.SUSPENDED) continue block7;
                        new ResumeXCommand(job.getId()).call();
                        continue block7;
                    }
                }
                throw new CommandException(ErrorCode.E1102, new Object[]{this.operation});
            }
            this.loadJobs();
            return this.workflowsInfo;
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0725, ex.getMessage(), ex);
        }
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        this.loadJobs();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    private void loadJobs() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.workflowsInfo = jpaService.execute(new WorkflowsJobGetJPAExecutor(this.filter, this.start, this.len));
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
    }
}

