/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.sla;

import java.util.Date;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.sla.SLASummaryBean;

public abstract class SLAJobHistoryXCommand
extends XCommand<Boolean> {
    protected String jobId;

    public SLAJobHistoryXCommand(String jobId) {
        super("SLAJobHistoryXCommand", "SLAJobHistoryXCommand", 1);
        this.jobId = jobId;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected boolean isReQueueRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return "sla_" + this.jobId;
    }

    @Override
    protected long getLockTimeOut() {
        return 0L;
    }

    @Override
    protected Boolean execute() throws CommandException {
        if (this.isJobEnded()) {
            try {
                this.updateSLASummary();
            }
            catch (XException e) {
                throw new CommandException(e);
            }
            return true;
        }
        this.LOG.debug("Job [{0}] is not finished", this.jobId);
        return false;
    }

    protected abstract boolean isJobEnded();

    protected abstract void updateSLASummary() throws CommandException, XException;

    protected void updateSLASummary(String id, Date startTime, Date endTime, String status) throws JPAExecutorException {
        SLASummaryBean sla = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, id);
        if (sla.getJobStatus().equals(status) && sla.getEventProcessed() == 8) {
            this.LOG.debug("SLA job is already updated", sla.getId(), sla.getEventProcessed(), sla.getJobStatus());
            return;
        }
        if (sla != null) {
            sla.setActualStart(startTime);
            sla.setActualEnd(endTime);
            if (startTime != null && endTime != null) {
                sla.setActualDuration(endTime.getTime() - startTime.getTime());
            }
            sla.setLastModifiedTime(new Date());
            sla.setEventProcessed(8);
            sla.setJobStatus(status);
            SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, sla);
            this.LOG.debug(" Stored SLA SummaryBean Job [{0}] eventProc = [{1}], status = [{2}]", sla.getId(), sla.getEventProcessed(), sla.getJobStatus());
        }
    }
}

