/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.sla;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.sla.SLAJobHistoryXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.util.LogUtils;

public class SLACoordActionJobHistoryXCommand
extends SLAJobHistoryXCommand {
    CoordinatorActionBean cAction = null;

    public SLACoordActionJobHistoryXCommand(String jobId) {
        super(jobId);
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.cAction = CoordActionQueryExecutor.getInstance().get(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION_FOR_SLA, this.jobId);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.cAction);
    }

    @Override
    protected void updateSLASummary() throws CommandException {
        try {
            this.updateSLASummaryForCoordAction(this.cAction);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    protected void updateSLASummaryForCoordAction(CoordinatorActionBean bean) throws JPAExecutorException {
        String wrkflowId = bean.getExternalId();
        if (wrkflowId != null) {
            WorkflowJobBean wrkflow = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_START_END_TIME, wrkflowId);
            if (wrkflow != null) {
                this.updateSLASummary(bean.getId(), wrkflow.getStartTime(), wrkflow.getEndTime(), bean.getStatusStr());
            }
        } else {
            this.updateSLASummary(bean.getId(), null, bean.getLastModifiedTime(), bean.getStatusStr());
        }
    }

    @Override
    protected boolean isJobEnded() {
        return this.cAction.isTerminalStatus();
    }
}

