/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordActionSkipXCommand;
import org.apache.oozie.command.coord.CoordActionTimeOutXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.input.dependency.CoordInputDependency;
import org.apache.oozie.executor.jpa.CoordActionGetForInputCheckJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordActionInputCheckXCommand
extends CoordinatorXCommand<Void> {
    public static final String COORD_EXECUTION_NONE_TOLERANCE = "oozie.coord.execution.none.tolerance";
    private final String actionId;
    public static final String CONF_COORD_INPUT_CHECK_REQUEUE_INTERVAL = "oozie.service.coord.input.check.requeue.interval";
    public static final String CONF_COORD_INPUT_CHECK_REQUEUE_INTERVAL_ADDITIONAL_DELAY = "oozie.service.coord.input.check.requeue.interval.additional.delay";
    private CoordinatorActionBean coordAction = null;
    private CoordinatorJobBean coordJob = null;
    private JPAService jpaService = null;
    private String jobId = null;

    public CoordActionInputCheckXCommand(String actionId, String jobId) {
        super("coord_action_input", "coord_action_input", 1);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.jobId = jobId;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.actionId);
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("[" + this.actionId + "]::ActionInputCheck:: Action is in WAITING state.");
        Date nominalTime = this.coordAction.getNominalTime();
        Date currentTime = new Date();
        if (nominalTime.compareTo(currentTime) > 0) {
            this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId(), this.coordAction.getJobId()), nominalTime.getTime() - currentTime.getTime());
            this.updateCoordAction(this.coordAction, false);
            this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: nominal Time is newer than current time, so requeue and wait. Current=" + DateUtils.formatDateOozieTZ(currentTime) + ", nominal=" + DateUtils.formatDateOozieTZ(nominalTime));
            return null;
        }
        StringBuilder actionXml = new StringBuilder(this.coordAction.getActionXml());
        boolean isChangeInDependency = false;
        try {
            XConfiguration actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
            Date now = new Date();
            if (this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.LAST_ONLY)) {
                Date nextNominalTime = CoordCommandUtils.computeNextNominalTime(this.coordJob, this.coordAction);
                if (nextNominalTime != null) {
                    if (now.after(nextNominalTime)) {
                        this.LOG.info("LAST_ONLY execution: Preparing to skip action [{0}] because the current time [{1}] is later than the nominal time [{2}] of the next action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nextNominalTime));
                        this.queue(new CoordActionSkipXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                        return null;
                    }
                    this.LOG.debug("LAST_ONLY execution: Not skipping action [{0}] because the current time [{1}] is earlier than the nominal time [{2}] of the next action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nextNominalTime));
                }
            } else if (this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.NONE)) {
                Calendar cal = Calendar.getInstance(DateUtils.getTimeZone(this.coordJob.getTimeZone()));
                cal.setTime(nominalTime);
                int tolerance = ConfigurationService.getInt(COORD_EXECUTION_NONE_TOLERANCE);
                cal.add(12, tolerance);
                if (now.after(cal.getTime())) {
                    this.LOG.info("NONE execution: Preparing to skip action [{0}] because the current time [{1}] is more than [{2}] minutes later than the nominal time [{3}] of the current action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), tolerance, DateUtils.formatDateOozieTZ(nominalTime));
                    this.queue(new CoordActionSkipXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                    return null;
                }
                this.LOG.debug("NONE execution: Not skipping action [{0}] because the current time [{1}] is earlier than [{2}] minutes later than the nominal time [{3}] of the current action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), tolerance, DateUtils.formatDateOozieTZ(this.coordAction.getNominalTime()));
            }
            StringBuilder existList = new StringBuilder();
            StringBuilder nonExistList = new StringBuilder();
            CoordInputDependency coordPullInputDependency = this.coordAction.getPullInputDependencies();
            CoordInputDependency coordPushInputDependency = this.coordAction.getPushInputDependencies();
            String missingDependencies = coordPullInputDependency.getMissingDependencies();
            StringBuilder nonResolvedList = new StringBuilder();
            CoordCommandUtils.getResolvedList(missingDependencies, nonExistList, nonResolvedList);
            String firstMissingDependency = "";
            if (nonExistList.length() > 0) {
                firstMissingDependency = nonExistList.toString().split("#")[0];
            }
            this.LOG.info("[" + this.actionId + "]::CoordActionInputCheck:: Missing deps:" + firstMissingDependency + " " + nonResolvedList.toString());
            boolean status = this.checkResolvedInput(actionXml, existList, nonExistList, actionConf);
            String nonExistListStr = nonExistList.toString();
            boolean isPushDependenciesMet = coordPushInputDependency.isDependencyMet();
            if (status && nonResolvedList.length() > 0) {
                status = isPushDependenciesMet ? this.checkUnResolvedInput(actionXml, actionConf) : false;
            }
            this.coordAction.setLastModifiedTime(currentTime);
            this.coordAction.setActionXml(actionXml.toString());
            isChangeInDependency = this.isChangeInDependency(nonExistList, missingDependencies, nonResolvedList, status);
            if (status && isPushDependenciesMet) {
                String newActionXml = CoordActionInputCheckXCommand.resolveCoordConfiguration(actionXml, actionConf, this.actionId, coordPullInputDependency, coordPushInputDependency);
                actionXml.replace(0, actionXml.length(), newActionXml);
                this.coordAction.setActionXml(actionXml.toString());
                this.coordAction.setStatus(CoordinatorAction.Status.READY);
                this.updateCoordAction(this.coordAction, true);
                new CoordActionReadyXCommand(this.coordAction.getJobId()).call();
            } else if (!this.isTimeout(currentTime)) {
                if (!status) {
                    long addtionalDelay = isChangeInDependency ? 0L : (long)ConfigurationService.getInt(CONF_COORD_INPUT_CHECK_REQUEUE_INTERVAL_ADDITIONAL_DELAY) * 1000L;
                    this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId(), this.coordAction.getJobId()), addtionalDelay + this.getCoordInputCheckRequeueInterval());
                }
                this.updateCoordAction(this.coordAction, isChangeInDependency);
            } else {
                if (!nonExistListStr.isEmpty() && isPushDependenciesMet) {
                    this.queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                } else {
                    this.queue(new CoordPushDependencyCheckXCommand(this.coordAction.getId()));
                }
                this.updateCoordAction(this.coordAction, isChangeInDependency);
            }
        }
        catch (AccessControlException e) {
            this.LOG.error((Object)"Permission error in ActionInputCheck", e);
            if (this.isTimeout(currentTime)) {
                this.LOG.debug("Queueing timeout command");
                Services.get().get(CallableQueueService.class).queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
            } else {
                Services.get().get(CallableQueueService.class).queue(new CoordActionInputCheckXCommand(this.coordAction.getId(), this.coordAction.getJobId()), 2L * this.getCoordInputCheckRequeueInterval());
            }
            this.updateCoordAction(this.coordAction, isChangeInDependency);
        }
        catch (Exception e) {
            if (this.isTimeout(currentTime)) {
                this.LOG.debug("Queueing timeout command");
                Services.get().get(CallableQueueService.class).queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
            }
            this.updateCoordAction(this.coordAction, isChangeInDependency);
            throw new CommandException(ErrorCode.E1021, e.getMessage(), e);
        }
        return null;
    }

    private boolean isChangeInDependency(StringBuilder nonExistList, String missingDependencies, StringBuilder nonResolvedList, boolean status) throws IOException {
        if (nonResolvedList.length() > 0 && !status) {
            nonExistList.append("!!").append((CharSequence)nonResolvedList);
        }
        return this.coordAction.getPullInputDependencies().isChangeInDependency(nonExistList, missingDependencies, nonResolvedList, status);
    }

    static String resolveCoordConfiguration(StringBuilder actionXml, Configuration actionConf, String actionId) throws Exception {
        return CoordActionInputCheckXCommand.resolveCoordConfiguration(actionXml, actionConf, actionId, null, null);
    }

    static String resolveCoordConfiguration(StringBuilder actionXml, Configuration actionConf, String actionId, CoordInputDependency pullDependencies, CoordInputDependency pushDependencies) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        ELEvaluator eval = CoordELEvaluator.createDataEvaluator(eAction, actionConf, actionId, pullDependencies, pushDependencies);
        CoordActionInputCheckXCommand.materializeDataProperties(eAction, actionConf, eval);
        return XmlUtils.prettyPrint(eAction).toString();
    }

    private boolean isTimeout(Date currentTime) {
        long waitingTime = (currentTime.getTime() - Math.max(this.coordAction.getNominalTime().getTime(), this.coordAction.getCreatedTime().getTime())) / 60000L;
        int timeOut = this.coordAction.getTimeOut();
        return timeOut >= 0 && waitingTime > (long)timeOut;
    }

    private void updateCoordAction(CoordinatorActionBean coordAction, boolean isChangeInDependency) throws CommandException {
        coordAction.setLastModifiedTime(new Date());
        if (this.jpaService != null) {
            try {
                if (isChangeInDependency) {
                    coordAction.setMissingDependencies(coordAction.getPullInputDependencies().serialize());
                    CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_INPUTCHECK, coordAction);
                    if (EventHandlerService.isEnabled() && coordAction.getStatus() != CoordinatorAction.Status.READY) {
                        CoordActionInputCheckXCommand.generateEvent(coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), null);
                    }
                } else {
                    CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_MODIFIED_DATE, coordAction);
                }
            }
            catch (Exception jex) {
                throw new CommandException(ErrorCode.E1021, jex.getMessage(), jex);
            }
        }
    }

    public long getCoordInputCheckRequeueInterval() {
        long requeueInterval = ConfigurationService.getLong(CONF_COORD_INPUT_CHECK_REQUEUE_INTERVAL);
        return requeueInterval;
    }

    protected boolean checkResolvedInput(StringBuilder actionXml, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws Exception {
        return this.coordAction.getPullInputDependencies().checkPullMissingDependencies(this.coordAction, existList, nonExistList);
    }

    protected boolean checkUnResolvedInput(CoordinatorActionBean coordAction, StringBuilder actionXml, Configuration conf) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        this.LOG.debug("[" + this.actionId + "]::ActionInputCheck:: Checking Latest/future");
        boolean allExist = this.checkUnresolvedInstances(coordAction, eAction, conf);
        if (allExist) {
            actionXml.replace(0, actionXml.length(), XmlUtils.prettyPrint(eAction).toString());
        }
        return allExist;
    }

    protected boolean checkUnResolvedInput(StringBuilder actionXml, Configuration conf) throws Exception {
        return this.checkUnResolvedInput(this.coordAction, actionXml, conf);
    }

    static void materializeDataProperties(Element eAction, Configuration conf, ELEvaluator eval) throws Exception {
        Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
        if (configElem != null) {
            for (Element propElem : configElem.getChildren("property", configElem.getNamespace())) {
                CoordActionInputCheckXCommand.resolveTagContents("value", propElem, eval);
            }
        }
    }

    private static void resolveTagContents(String tagName, Element elem, ELEvaluator eval) throws Exception {
        if (elem == null) {
            return;
        }
        Element tagElem = elem.getChild(tagName, elem.getNamespace());
        if (tagElem != null) {
            String updated = CoordELFunctions.evalAndWrap(eval, tagElem.getText());
            tagElem.removeContent();
            tagElem.addContent(updated);
        } else {
            XLog.getLog(CoordActionInputCheckXCommand.class).warn(" Value NOT FOUND " + tagName);
        }
    }

    private boolean checkUnresolvedInstances(CoordinatorActionBean coordAction, Element eAction, Configuration actionConf) throws Exception {
        boolean ret = coordAction.getPullInputDependencies().checkUnresolved(coordAction, eAction);
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        if (outputList != null) {
            for (Element dEvent : outputList.getChildren("data-out", eAction.getNamespace())) {
                if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
                throw new CommandException(ErrorCode.E1006, "coord:latest()/future()", " not permitted in output-event ");
            }
        }
        return ret;
    }

    protected String getCoordActionErrorCode() {
        if (this.coordAction != null) {
            return this.coordAction.getErrorCode();
        }
        return null;
    }

    protected String getCoordActionErrorMsg() {
        if (this.coordAction != null) {
            return this.coordAction.getErrorMessage();
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        if (this.jpaService == null) {
            this.jpaService = Services.get().get(JPAService.class);
        }
        try {
            this.coordAction = this.jpaService.execute(new CoordActionGetForInputCheckJPAExecutor(this.actionId));
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_INPUT_CHECK, this.coordAction.getJobId());
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        LogUtils.setLogInfo(this.coordAction);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordAction.getStatus() != CoordinatorAction.Status.WAITING) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordActionInputCheck:: Ignoring action. Should be in WAITING state, but state=" + this.coordAction.getStatus());
        }
        if (StatusUtils.getStatusForCoordActionInputCheck(this.coordJob)) {
            return;
        }
        if (this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.RUNNINGWITHERROR && this.coordJob.getStatus() != Job.Status.PAUSED && this.coordJob.getStatus() != Job.Status.PAUSEDWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordActionInputCheck:: Ignoring action. Coordinator job is not in RUNNING/RUNNINGWITHERROR/PAUSED/PAUSEDWITHERROR state, but state=" + this.coordJob.getStatus());
        }
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

