/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import java.util.Map;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.executor.jpa.CoordJobInfoGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BulkCoordXCommand
extends XCommand<CoordinatorJobInfo> {
    private Map<String, List<String>> filter;
    private final int start;
    private final int len;
    private CoordinatorJobInfo coordinatorJobInfo;
    private OperationType operation;

    public BulkCoordXCommand(Map<String, List<String>> filter, int start, int length, OperationType operation) {
        super("bulkcoord" + (Object)((Object)operation), "bulkcoord" + (Object)((Object)operation), 1);
        this.filter = filter;
        this.start = start;
        this.len = length;
        this.operation = operation;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected void loadState() throws CommandException {
        this.loadJobs();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected CoordinatorJobInfo execute() throws CommandException {
        List<CoordinatorJobBean> jobs = this.coordinatorJobInfo.getCoordJobs();
        block5: for (CoordinatorJobBean job : jobs) {
            switch (this.operation) {
                case Kill: {
                    if (job.getStatus() == Job.Status.SUCCEEDED || job.getStatus() == Job.Status.FAILED || job.getStatus() == Job.Status.DONEWITHERROR || job.getStatus() == Job.Status.KILLED || job.getStatus() == Job.Status.IGNORED) continue block5;
                    new CoordKillXCommand(job.getId()).call();
                    continue block5;
                }
                case Suspend: {
                    if (job.getStatus() == Job.Status.SUCCEEDED || job.getStatus() == Job.Status.FAILED || job.getStatus() == Job.Status.KILLED || job.getStatus() == Job.Status.IGNORED) continue block5;
                    new CoordSuspendXCommand(job.getId()).call();
                    continue block5;
                }
                case Resume: {
                    if (job.getStatus() != Job.Status.SUSPENDED && job.getStatus() != Job.Status.SUSPENDEDWITHERROR && job.getStatus() != Job.Status.PREPSUSPENDED) continue block5;
                    new CoordResumeXCommand(job.getId()).call();
                    continue block5;
                }
            }
            throw new CommandException(ErrorCode.E1102, new Object[]{this.operation});
        }
        this.loadJobs();
        return this.coordinatorJobInfo;
    }

    private void loadJobs() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordinatorJobInfo = jpaService.execute(new CoordJobInfoGetJPAExecutor(this.filter, this.start, this.len));
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
    }
}

