/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.List;
import java.util.Map;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.command.bundle.BundleJobResumeXCommand;
import org.apache.oozie.command.bundle.BundleJobSuspendXCommand;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.executor.jpa.BundleJobInfoGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BulkBundleXCommand
extends XCommand<BundleJobInfo> {
    private Map<String, List<String>> filter;
    private final int start;
    private final int len;
    private BundleJobInfo bundleJobInfo;
    private OperationType operation;

    public BulkBundleXCommand(Map<String, List<String>> filter, int start, int length, OperationType operation) {
        super("bulkbundle" + (Object)((Object)operation), "bulkbundle" + (Object)((Object)operation), 1);
        this.filter = filter;
        this.start = start;
        this.len = length;
        this.operation = operation;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected void loadState() throws CommandException {
        this.loadBundleJobs();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected BundleJobInfo execute() throws CommandException {
        List<BundleJobBean> jobs = this.bundleJobInfo.getBundleJobs();
        block5: for (BundleJobBean job : jobs) {
            switch (this.operation) {
                case Kill: {
                    if (job.getStatus() == Job.Status.SUCCEEDED || job.getStatus() == Job.Status.FAILED || job.getStatus() == Job.Status.DONEWITHERROR || job.getStatus() == Job.Status.KILLED) continue block5;
                    new BundleKillXCommand(job.getId()).call();
                    continue block5;
                }
                case Suspend: {
                    if (job.getStatus() == Job.Status.SUCCEEDED || job.getStatus() == Job.Status.FAILED || job.getStatus() == Job.Status.KILLED || job.getStatus() == Job.Status.DONEWITHERROR) continue block5;
                    new BundleJobSuspendXCommand(job.getId()).call();
                    continue block5;
                }
                case Resume: {
                    if (job.getStatus() != Job.Status.SUSPENDED && job.getStatus() != Job.Status.SUSPENDEDWITHERROR && job.getStatus() != Job.Status.PREPSUSPENDED) continue block5;
                    new BundleJobResumeXCommand(job.getId()).call();
                    continue block5;
                }
            }
            throw new CommandException(ErrorCode.E1102, new Object[]{this.operation});
        }
        this.loadBundleJobs();
        return this.bundleJobInfo;
    }

    private void loadBundleJobs() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.bundleJobInfo = jpaService.execute(new BundleJobInfoGetJPAExecutor(this.filter, this.start, this.len));
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
    }
}

