/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.util.LogUtils;

public abstract class SLAAlertsXCommand
extends XCommand<Void> {
    private String jobId;

    public SLAAlertsXCommand(String jobId, String name, String type) {
        super(name, type, 1);
        this.jobId = jobId;
    }

    @Override
    protected final boolean isLockRequired() {
        return true;
    }

    @Override
    public final String getEntityKey() {
        return this.getJobId();
    }

    public final String getJobId() {
        return this.jobId;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.jobId);
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            if (!this.executeSlaCommand() && !this.isJobRequest()) {
                throw new CommandException(ErrorCode.E1026, "No record found");
            }
        }
        catch (ServiceException e) {
            throw new CommandException(e);
        }
        this.updateJob();
        return null;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    protected void validateSLAChangeParam(Map<String, String> slaParams) throws CommandException, PreconditionException {
        for (String key : slaParams.keySet()) {
            if (key.equals("sla-nominal-time") || key.equals("sla-should-start") || key.equals("sla-should-end") || key.equals("sla-max-duration")) continue;
            throw new CommandException(ErrorCode.E1027, "Unsupported parameter " + key);
        }
    }

    protected abstract boolean executeSlaCommand() throws ServiceException, CommandException;

    protected abstract void updateJob() throws CommandException;

    protected abstract boolean isJobRequest() throws CommandException;
}

