/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.ShellMain;
import org.apache.oozie.service.ConfigurationService;
import org.jdom.Element;
import org.jdom.Namespace;

public class ShellActionExecutor
extends JavaActionExecutor {
    public String OOZIE_LAUNCHER_CHILD_ENV = "mapred.child.env";
    public String OOZIE_LAUNCHER_MAP_ENV = "mapreduce.map.env";

    public ShellActionExecutor() {
        super("shell");
    }

    @Override
    public List<Class> getLauncherClasses() {
        return null;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", ShellMain.class.getName());
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        String exec = actionXml.getChild("exec", ns).getTextTrim();
        String execName = new Path(exec).getName();
        actionConf.set("oozie.shell.exec", execName);
        this.setListInConf("argument", actionXml, actionConf, "oozie.shell.args", false);
        this.setListInConf("env-var", actionXml, actionConf, "oozie.shell.envs", true);
        actionConf.setBoolean("oozie.shell.capture-output", actionXml.getChild("capture-output", ns) != null);
        boolean setupHadoopConfDir = actionConf.getBoolean("oozie.action.shell.setup.hadoop.conf.dir", ConfigurationService.getBoolean("oozie.action.shell.setup.hadoop.conf.dir"));
        actionConf.setBoolean("oozie.action.shell.setup.hadoop.conf.dir", setupHadoopConfDir);
        boolean writeL4J = actionConf.getBoolean("oozie.action.shell.setup.hadoop.conf.dir.write.log4j.properties", ConfigurationService.getBoolean("oozie.action.shell.setup.hadoop.conf.dir.write.log4j.properties"));
        actionConf.setBoolean("oozie.action.shell.setup.hadoop.conf.dir.write.log4j.properties", writeL4J);
        if (writeL4J) {
            String l4jContent = actionConf.get("oozie.action.shell.setup.hadoop.conf.dir.log4j.content", ConfigurationService.get("oozie.action.shell.setup.hadoop.conf.dir.log4j.content"));
            actionConf.set("oozie.action.shell.setup.hadoop.conf.dir.log4j.content", l4jContent);
        }
        return actionConf;
    }

    protected void setListInConf(String tag, Element actionXml, Configuration actionConf, String key, boolean checkKeyValue) throws ActionExecutorException {
        String[] strTagValue = null;
        Namespace ns = actionXml.getNamespace();
        List eTags = actionXml.getChildren(tag, ns);
        if (eTags != null && eTags.size() > 0) {
            strTagValue = new String[eTags.size()];
            for (int i = 0; i < eTags.size(); ++i) {
                strTagValue[i] = ((Element)eTags.get(i)).getTextTrim();
                if (!checkKeyValue) continue;
                this.checkPair(strTagValue[i]);
            }
        }
        MapReduceMain.setStrings((Configuration)actionConf, (String)key, strTagValue);
    }

    private void checkPair(String pair) throws ActionExecutorException {
        String[] varValue = pair.split("=");
        if (varValue == null || varValue.length <= 1) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA010", "Wrong ENV format [{0}] in <env-var> , key=value format expected ", pair);
        }
    }

    @Override
    protected Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        super.setupLauncherConf(conf, actionXml, appPath, context);
        this.addDefaultChildEnv(conf);
        return conf;
    }

    protected void addDefaultChildEnv(Configuration conf) {
        String envValues = "PATH=.:$PATH";
        this.updateProperty(conf, this.OOZIE_LAUNCHER_MAP_ENV, envValues);
        this.updateProperty(conf, this.OOZIE_LAUNCHER_CHILD_ENV, envValues);
    }

    private void updateProperty(Configuration conf, String propertyName, String appendValue) {
        if (conf != null) {
            String val = conf.get(propertyName, "");
            if (val.length() > 0) {
                val = val + ",";
            }
            val = val + appendValue;
            conf.set(propertyName, val);
            this.LOG.debug("action conf is updated with default value for property " + propertyName + ", old value :" + conf.get(propertyName, "") + ", new value :" + val);
        }
    }
}

