/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.email;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class EmailActionExecutor
extends ActionExecutor {
    public static final String CONF_PREFIX = "oozie.email.";
    public static final String EMAIL_SMTP_HOST = "oozie.email.smtp.host";
    public static final String EMAIL_SMTP_PORT = "oozie.email.smtp.port";
    public static final String EMAIL_SMTP_AUTH = "oozie.email.smtp.auth";
    public static final String EMAIL_SMTP_USER = "oozie.email.smtp.username";
    public static final String EMAIL_SMTP_PASS = "oozie.email.smtp.password";
    public static final String EMAIL_SMTP_FROM = "oozie.email.from.address";
    public static final String EMAIL_SMTP_SOCKET_TIMEOUT_MS = "oozie.email.smtp.socket.timeout.ms";
    public static final String EMAIL_ATTACHMENT_ENABLED = "oozie.email.attachment.enabled";
    private static final String TO = "to";
    private static final String CC = "cc";
    private static final String BCC = "bcc";
    private static final String SUB = "subject";
    private static final String BOD = "body";
    private static final String ATTACHMENT = "attachment";
    private static final String COMMA = ",";
    private static final String CONTENT_TYPE = "content_type";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private XLog LOG = XLog.getLog(this.getClass());
    public static final String EMAIL_ATTACHMENT_ERROR_MSG = "\n Note: This email is missing configured email attachments as sending attachments in email action is disabled in the Oozie server. It could be for security compliance with data protection or other reasons";

    public EmailActionExecutor() {
        super("email");
    }

    @Override
    public void initActionType() {
        super.initActionType();
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            context.setStartData("-", "-", "-");
            Element actionXml = XmlUtils.parseXml(action.getConf());
            this.validateAndMail(context, actionXml);
            context.setExecutionData("OK", null);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    protected void validateAndMail(ActionExecutor.Context context, Element element) throws ActionExecutorException {
        String contentType;
        String[] bccs;
        Namespace ns = element.getNamespace();
        String[] tos = new String[]{};
        String[] ccs = new String[]{};
        String subject = "";
        String body = "";
        String[] attachments = new String[]{};
        Object child = null;
        String text = element.getChildTextTrim(TO, ns);
        if (text.isEmpty()) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM001", "No receipents were specified in the to-address field.");
        }
        tos = text.split(COMMA);
        try {
            ccs = element.getChildTextTrim(CC, ns).split(COMMA);
        }
        catch (Exception e) {
            ccs = new String[]{};
        }
        try {
            bccs = element.getChildTextTrim(BCC, ns).split(COMMA);
        }
        catch (Exception e) {
            bccs = new String[]{};
        }
        subject = element.getChildTextTrim(SUB, ns);
        body = element.getChildTextTrim(BOD, ns);
        String attachment = element.getChildTextTrim(ATTACHMENT, ns);
        if (attachment != null) {
            attachments = attachment.split(COMMA);
        }
        if ((contentType = element.getChildTextTrim(CONTENT_TYPE, ns)) == null || contentType.isEmpty()) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        this.email(tos, ccs, bccs, subject, body, attachments, contentType, context.getWorkflow().getUser());
    }

    public void email(String[] to, String[] cc, String subject, String body, String[] attachments, String contentType, String user) throws ActionExecutorException {
        this.email(to, cc, new String[0], subject, body, attachments, contentType, user);
    }

    public void email(String[] to, String[] cc, String[] bcc, String subject, String body, String[] attachments, String contentType, String user) throws ActionExecutorException {
        String smtpHost = ConfigurationService.get(EMAIL_SMTP_HOST);
        Integer smtpPortInt = ConfigurationService.getInt(EMAIL_SMTP_PORT);
        Boolean smtpAuthBool = ConfigurationService.getBoolean(EMAIL_SMTP_AUTH);
        String smtpUser = ConfigurationService.get(EMAIL_SMTP_USER);
        String smtpPassword = ConfigurationService.getPassword(EMAIL_SMTP_PASS, "");
        String fromAddr = ConfigurationService.get(EMAIL_SMTP_FROM);
        Integer timeoutMillisInt = ConfigurationService.getInt(EMAIL_SMTP_SOCKET_TIMEOUT_MS);
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", smtpHost);
        properties.setProperty("mail.smtp.port", smtpPortInt.toString());
        properties.setProperty("mail.smtp.auth", smtpAuthBool.toString());
        properties.setProperty("mail.smtp.connectiontimeout", timeoutMillisInt.toString());
        properties.setProperty("mail.smtp.timeout", timeoutMillisInt.toString());
        properties.setProperty("mail.smtp.writetimeout", timeoutMillisInt.toString());
        Session session = smtpAuthBool == false ? Session.getInstance((Properties)properties) : Session.getInstance((Properties)properties, (Authenticator)new JavaMailAuthenticator(smtpUser, smtpPassword));
        MimeMessage message = new MimeMessage(session);
        ArrayList<InternetAddress> toAddrs = new ArrayList<InternetAddress>(to.length);
        ArrayList<InternetAddress> ccAddrs = new ArrayList<InternetAddress>(cc.length);
        ArrayList<InternetAddress> bccAddrs = new ArrayList<InternetAddress>(bcc.length);
        try {
            InternetAddress from = new InternetAddress(fromAddr);
            message.setFrom((Address)from);
        }
        catch (AddressException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM002", "Bad from address specified in ${oozie.email.from.address}.", new Object[]{e});
        }
        catch (MessagingException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM003", "Error setting a from address in the message.", new Object[]{e});
        }
        try {
            for (String toStr : to) {
                toAddrs.add(new InternetAddress(toStr.trim()));
            }
            message.addRecipients(Message.RecipientType.TO, (Address[])toAddrs.toArray(new InternetAddress[0]));
            for (String ccStr : cc) {
                ccAddrs.add(new InternetAddress(ccStr.trim()));
            }
            message.addRecipients(Message.RecipientType.CC, (Address[])ccAddrs.toArray(new InternetAddress[0]));
            for (String bccStr : bcc) {
                bccAddrs.add(new InternetAddress(bccStr.trim()));
            }
            message.addRecipients(Message.RecipientType.BCC, (Address[])bccAddrs.toArray(new InternetAddress[0]));
            message.setSubject(subject);
            if (attachments != null && attachments.length > 0 && ConfigurationService.getBoolean(EMAIL_ATTACHMENT_ENABLED)) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart bodyTextPart = new MimeBodyPart();
                bodyTextPart.setText(body);
                multipart.addBodyPart((BodyPart)bodyTextPart);
                for (String attachment : attachments) {
                    URI attachUri = new URI(attachment);
                    if (attachUri.getScheme() != null && attachUri.getScheme().equals("file")) {
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM008", "Encountered an error when attaching a file. A local file cannot be attached:" + attachment);
                    }
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    URIDataSource source = new URIDataSource(attachUri, user);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(new File(attachment).getName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                message.setContent((Multipart)multipart);
            } else {
                if (attachments != null && attachments.length > 0 && !ConfigurationService.getBoolean(EMAIL_ATTACHMENT_ENABLED)) {
                    body = body + EMAIL_ATTACHMENT_ERROR_MSG;
                }
                message.setContent((Object)body, contentType);
            }
        }
        catch (AddressException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM004", "Bad address format in <to> or <cc> or <bcc>.", new Object[]{e});
        }
        catch (MessagingException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM005", "An error occured while adding recipients.", new Object[]{e});
        }
        catch (URISyntaxException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM008", "Encountered an error when attaching a file", e);
        }
        catch (HadoopAccessorException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM008", "Encountered an error when attaching a file", e);
        }
        try {
            Transport.send((Message)message);
        }
        catch (NoSuchProviderException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM006", "Could not find an SMTP transport provider to email.", new Object[]{e});
        }
        catch (MessagingException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM007", "Encountered an error while sending the email message over SMTP.", new Object[]{e});
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        String externalStatus = action.getExternalStatus();
        WorkflowAction.Status status = externalStatus.equals("OK") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
        context.setEndData(status, this.getActionSignal(status));
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }

    class URIDataSource
    implements DataSource {
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        FileSystem fs;
        URI uri;

        public URIDataSource(URI uri, String user) throws HadoopAccessorException {
            this.uri = uri;
            JobConf fsConf = this.has.createJobConf(uri.getAuthority());
            this.fs = this.has.createFileSystem(user, uri, (Configuration)fsConf);
        }

        public InputStream getInputStream() throws IOException {
            return this.fs.open(new Path(this.uri));
        }

        public OutputStream getOutputStream() throws IOException {
            return this.fs.create(new Path(this.uri));
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public String getName() {
            return this.uri.getPath();
        }
    }

    public static class JavaMailAuthenticator
    extends Authenticator {
        String user;
        String password;

        public JavaMailAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

