/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.decision;

import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class DecisionActionExecutor
extends ActionExecutor {
    public static final String ACTION_TYPE = "switch";
    private static final String TRUE = "true";
    public static final String XML_ERROR = "XML_ERROR";

    public DecisionActionExecutor() {
        super(ACTION_TYPE);
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        XLog log = XLog.getLog(this.getClass());
        log.trace("start() begins");
        try {
            Element def;
            String confStr = action.getConf();
            context.setStartData("-", "-", "-");
            Element conf = XmlUtils.parseXml(confStr);
            Namespace ns = conf.getNamespace();
            String externalState = null;
            for (Element eval : conf.getChildren("case", ns)) {
                if (!TRUE.equals(eval.getTextTrim())) continue;
                externalState = eval.getAttributeValue("to");
                break;
            }
            if (externalState == null && (def = conf.getChild("default", ns)) != null) {
                externalState = def.getAttributeValue("to");
            }
            if (externalState == null) {
                throw new IllegalStateException("Transition cannot be NULL");
            }
            context.setExecutionData(externalState, null);
        }
        catch (JDOMException ex) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, XML_ERROR, ex.getMessage(), new Object[]{ex});
        }
        finally {
            log.trace("start() ends");
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        context.setEndData(WorkflowAction.Status.OK, action.getExternalStatus());
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }
}

