/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.util.XConfiguration;

public class LocalOozieClient
extends OozieClient {
    private DagEngine dagEngine;

    public LocalOozieClient(DagEngine dagEngine) {
        this.dagEngine = dagEngine;
    }

    public String getOozieUrl() {
        return "localoozie";
    }

    public String getProtocolUrl() throws OozieClientException {
        return "localoozie";
    }

    public synchronized void validateWSVersion() throws OozieClientException {
    }

    public Properties createConfiguration() {
        Properties conf = new Properties();
        if (this.dagEngine != null) {
            conf.setProperty("user.name", this.dagEngine.getUser());
        }
        conf.setProperty("group.name", "users");
        return conf;
    }

    public void setHeader(String name, String value) {
    }

    public String getHeader(String name) {
        return null;
    }

    public void removeHeader(String name) {
    }

    public Iterator<String> getHeaderNames() {
        return Collections.EMPTY_SET.iterator();
    }

    public String submit(Properties conf) throws OozieClientException {
        try {
            return this.dagEngine.submitJob(new XConfiguration(conf), false);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void start(String jobId) throws OozieClientException {
        try {
            this.dagEngine.start(jobId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public String run(Properties conf) throws OozieClientException {
        try {
            return this.dagEngine.submitJob(new XConfiguration(conf), true);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void reRun(String jobId, Properties conf) throws OozieClientException {
        try {
            this.dagEngine.reRun(jobId, new XConfiguration(conf));
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void suspend(String jobId) throws OozieClientException {
        try {
            this.dagEngine.suspend(jobId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void resume(String jobId) throws OozieClientException {
        try {
            this.dagEngine.resume(jobId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void kill(String jobId) throws OozieClientException {
        try {
            this.dagEngine.kill(jobId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public WorkflowJob getJobInfo(String jobId) throws OozieClientException {
        try {
            return this.dagEngine.getJob(jobId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public List<WorkflowJob> getJobsInfo(String filter, int start, int len) throws OozieClientException {
        try {
            return this.dagEngine.getJobs(filter, start, len).getWorkflows();
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public List<WorkflowJob> getJobsInfo(String filter) throws OozieClientException {
        return this.getJobsInfo(filter, 1, 100);
    }

    public String getJobId(String externalId) throws OozieClientException {
        try {
            return this.dagEngine.getJobIdForExternalId(externalId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }
}

