/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.snative;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.swift.util.SwiftObjectPath;

public class SwiftFileStatus
extends FileStatus {
    private SwiftObjectPath dloPrefix = null;
    private boolean isPseudoDirFlag = false;

    public SwiftFileStatus() {
    }

    public SwiftFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, Path path) {
        this(length, isdir, block_replication, blocksize, modification_time, path, null);
    }

    public SwiftFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, Path path, SwiftObjectPath dloPrefix) {
        super(length, isdir, block_replication, blocksize, modification_time, path);
        this.dloPrefix = dloPrefix;
    }

    public SwiftFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path path) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, path);
    }

    public static SwiftFileStatus createPseudoDirStatus(Path path) {
        SwiftFileStatus status = new SwiftFileStatus(0L, true, 1, 0L, System.currentTimeMillis(), path);
        status.isPseudoDirFlag = true;
        return status;
    }

    public boolean isFile() {
        return !this.isDir();
    }

    public boolean isDirectory() {
        return this.isDir();
    }

    public boolean isDLO() {
        return this.dloPrefix != null;
    }

    public SwiftObjectPath getDLOPrefix() {
        return this.dloPrefix;
    }

    public boolean isPseudoDir() {
        return this.isPseudoDirFlag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("{ ");
        sb.append("path=").append(this.getPath());
        sb.append("; isDirectory=").append(this.isDirectory());
        sb.append("; length=").append(this.getLen());
        sb.append("; blocksize=").append(this.getBlockSize());
        sb.append("; modification_time=").append(this.getModificationTime());
        sb.append("}");
        return sb.toString();
    }
}

