/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.PrintStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.map.InverseMapper;
import org.apache.hadoop.mapreduce.lib.map.RegexMapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Grep
extends Configured
implements Tool {
    private Grep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Grep <inDir> <outDir> <regex> [<group>]");
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return 2;
        }
        Path tempDir = new Path("grep-temp-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        Configuration conf = this.getConf();
        conf.set(RegexMapper.PATTERN, args[2]);
        if (args.length == 4) {
            conf.set(RegexMapper.GROUP, args[3]);
        }
        Job grepJob = new Job(conf);
        try {
            grepJob.setJobName("grep-search");
            FileInputFormat.setInputPaths((Job)grepJob, (String)args[0]);
            grepJob.setMapperClass(RegexMapper.class);
            grepJob.setCombinerClass(LongSumReducer.class);
            grepJob.setReducerClass(LongSumReducer.class);
            FileOutputFormat.setOutputPath((Job)grepJob, (Path)tempDir);
            grepJob.setOutputFormatClass(SequenceFileOutputFormat.class);
            grepJob.setOutputKeyClass(Text.class);
            grepJob.setOutputValueClass(LongWritable.class);
            grepJob.waitForCompletion(true);
            Job sortJob = new Job(conf);
            sortJob.setJobName("grep-sort");
            FileInputFormat.setInputPaths((Job)sortJob, (Path[])new Path[]{tempDir});
            sortJob.setInputFormatClass(SequenceFileInputFormat.class);
            sortJob.setMapperClass(InverseMapper.class);
            sortJob.setNumReduceTasks(1);
            FileOutputFormat.setOutputPath((Job)sortJob, (Path)new Path(args[1]));
            sortJob.setSortComparatorClass(LongWritable.DecreasingComparator.class);
            sortJob.waitForCompletion(true);
        }
        finally {
            FileSystem.get((Configuration)conf).delete(tempDir, true);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new Grep(), (String[])args);
        System.exit(res);
    }
}

