# == class: zaqar::management::mongodb
#
# [*uri*]
#   Mongodb Connection URI. Required.
#
# [*ssl_keyfile*]
#   The private keyfile used to identify the local connection against
#   mongod. Default $facts['os_service_default']
#   Defaults to $facts['os_service_default'].
#
# [*ssl_certfile*]
#   The certificate file used to identify the local connection against
#   mongod. (string value)
#   Defaults to $facts['os_service_default'].
#
# [*ssl_cert_reqs*]
#   Specifies whether a certificate is required from the other side of
#   the connection, and whether it will be validated if provided. It
#   must be one of the three values ``CERT_NONE``(certificates ignored),
#   ``CERT_OPTIONAL``(not required, but validated if provided), or
#   ``CERT_REQUIRED``(required and validated).
#   Defaults to $facts['os_service_default'].
#
# [*ssl_ca_certs*]
#   The ca_certs file contains a set of concatenated "certification
#   authority" certificates, which are used to validate certificates
#   passed from the other end of the connection.
#   Defaults to $facts['os_service_default'].
#
# [*database*]
#   Database name. (string value). Defaults to $facts['os_service_default'].
#
# [*max_attempts*]
#   Maximum number of times to retry a failed operation. Currently only
#   used for retrying a message post.
#   Defaults to $facts['os_service_default'].
#
# [*max_retry_sleep*]
#   Maximum sleep interval between retries (actual sleep time increases
#   linearly according to number of attempts performed).
#   Defaults to $facts['os_service_default'].
#
# [*max_retry_jitter*]
#   Maximum jitter interval, to be added to the sleep interval, in order
#   to decrease probability that parallel requests will retry at the
#   same instant. (floating point value)
#   Defaults to $facts['os_service_default'].
#
# [*max_reconnect_attempts*]
#   Maximum number of times to retry an operation that failed due to a
#   primary node failover. (integer value)
#   Defaults to $facts['os_service_default'].
#
# [*reconnect_sleep*]
#   Base sleep interval between attempts to reconnect after a primary
#   node failover. The actual sleep time increases exponentially (power
#   of 2) each time the operation is retried. (floating point value)
#   Defaults to $facts['os_service_default'].
#
class zaqar::management::mongodb(
  $uri,
  $ssl_keyfile            = $facts['os_service_default'],
  $ssl_certfile           = $facts['os_service_default'],
  $ssl_cert_reqs          = $facts['os_service_default'],
  $ssl_ca_certs           = $facts['os_service_default'],
  $database               = $facts['os_service_default'],
  $max_attempts           = $facts['os_service_default'],
  $max_retry_sleep        = $facts['os_service_default'],
  $max_retry_jitter       = $facts['os_service_default'],
  $max_reconnect_attempts = $facts['os_service_default'],
  $reconnect_sleep        = $facts['os_service_default'],
) {

  include zaqar::deps

  zaqar_config {
    'drivers:management_store:mongodb/uri':                    value => $uri, secret => true;
    'drivers:management_store:mongodb/ssl_keyfile':            value => $ssl_keyfile;
    'drivers:management_store:mongodb/ssl_certfile':           value => $ssl_certfile;
    'drivers:management_store:mongodb/ssl_cert_reqs':          value => $ssl_cert_reqs;
    'drivers:management_store:mongodb/ssl_ca_certs':           value => $ssl_ca_certs;
    'drivers:management_store:mongodb/database':               value => $database;
    'drivers:management_store:mongodb/max_attempts':           value => $max_attempts;
    'drivers:management_store:mongodb/max_retry_sleep':        value => $max_retry_sleep;
    'drivers:management_store:mongodb/max_retry_jitter':       value => $max_retry_jitter;
    'drivers:management_store:mongodb/max_reconnect_attempts': value => $max_reconnect_attempts;
    'drivers:management_store:mongodb/reconnect_sleep':        value => $reconnect_sleep;
  }

}
