# == Define: pacemaker::stonith::fence_amt
#
# Module for managing Stonith for fence_amt.
#
# WARNING: Generated by "rake generate_stonith", manual changes will
# be lost.
#
# === Parameters
#
# [*ipport*]
#   TCP/UDP port to use for connection with device
#
# [*port*]
#   IP address or hostname of fencing device (together with --port-as-ip)
#
# [*inet6_only*]
#   Forces agent to use IPv6 addresses only
#
# [*ipaddr*]
#   IP Address or Hostname
#
# [*inet4_only*]
#   Forces agent to use IPv4 addresses only
#
# [*method*]
#   Method to fence (onoff|cycle)
#
# [*passwd_script*]
#   Script to retrieve password
#
# [*passwd*]
#   Login password or passphrase
#
# [*boot_option*]
#   Change the default boot behavior of the machine.
#
# [*action*]
#   Fencing Action
#
# [*plug*]
#   IP address or hostname of fencing device (together with --port-as-ip)
#
# [*ip*]
#   IP Address or Hostname
#
# [*password*]
#   Login password or passphrase
#
# [*password_script*]
#   Script to retrieve password
#
# [*verbose*]
#   Verbose mode
#
# [*debug*]
#   Write debug information to given file
#
# [*debug_file*]
#   Write debug information to given file
#
# [*power_wait*]
#   Wait X seconds after issuing ON/OFF
#
# [*login_timeout*]
#   Wait X seconds for cmd prompt after login
#
# [*power_timeout*]
#   Test X seconds for status change after ON/OFF
#
# [*delay*]
#   Wait X seconds before fencing is started
#
# [*shell_timeout*]
#   Wait X seconds for cmd prompt after issuing command
#
# [*amttool_path*]
#   Path to amttool binary
#
# [*port_as_ip*]
#   Make "port/plug" to be an alias to IP address
#
# [*retry_on*]
#   Count of attempts to retry power on
#
# [*sudo*]
#   Use sudo (without password) when calling 3rd party sotfware.
#
# [*use_sudo*]
#   Use sudo (without password) when calling 3rd party sotfware.
#
#  [*interval*]
#   Interval between tries.
#
# [*ensure*]
#   The desired state of the resource.
#
# [*tries*]
#   The number of tries.
#
# [*try_sleep*]
#   Time to sleep between tries.
#
# [*pcmk_host_list*]
#   List of Pacemaker hosts.
#
# [*meta_attr*]
#   (optional) String of meta attributes
#   Defaults to undef
#
# === Dependencies
#  None
#
# === Authors
#
# Generated by rake generate_stonith task.
#
# === Copyright
#
# Copyright (C) 2016 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
define pacemaker::stonith::fence_amt (
  $ipport          = undef,
  $port            = undef,
  $inet6_only      = undef,
  $ipaddr          = undef,
  $inet4_only      = undef,
  $method          = undef,
  $passwd_script   = undef,
  $passwd          = undef,
  $boot_option     = undef,
  $action          = undef,
  $plug            = undef,
  $ip              = undef,
  $password        = undef,
  $password_script = undef,
  $verbose         = undef,
  $debug           = undef,
  $debug_file      = undef,
  $power_wait      = undef,
  $login_timeout   = undef,
  $power_timeout   = undef,
  $delay           = undef,
  $shell_timeout   = undef,
  $amttool_path    = undef,
  $port_as_ip      = undef,
  $retry_on        = undef,
  $sudo            = undef,
  $use_sudo        = undef,

  $meta_attr       = undef,
  $interval        = '60s',
  $ensure          = present,
  $pcmk_host_list  = undef,

  $tries           = undef,
  $try_sleep       = undef,

) {
  $ipport_chunk = $ipport ? {
    undef   => '',
    default => "ipport=\"${ipport}\"",
  }
  $port_chunk = $port ? {
    undef   => '',
    default => "port=\"${port}\"",
  }
  $inet6_only_chunk = $inet6_only ? {
    undef   => '',
    default => "inet6_only=\"${inet6_only}\"",
  }
  $ipaddr_chunk = $ipaddr ? {
    undef   => '',
    default => "ipaddr=\"${ipaddr}\"",
  }
  $inet4_only_chunk = $inet4_only ? {
    undef   => '',
    default => "inet4_only=\"${inet4_only}\"",
  }
  $method_chunk = $method ? {
    undef   => '',
    default => "method=\"${method}\"",
  }
  $passwd_script_chunk = $passwd_script ? {
    undef   => '',
    default => "passwd_script=\"${passwd_script}\"",
  }
  $passwd_chunk = $passwd ? {
    undef   => '',
    default => "passwd=\"${passwd}\"",
  }
  $boot_option_chunk = $boot_option ? {
    undef   => '',
    default => "boot_option=\"${boot_option}\"",
  }
  $action_chunk = $action ? {
    undef   => '',
    default => "action=\"${action}\"",
  }
  $plug_chunk = $plug ? {
    undef   => '',
    default => "plug=\"${plug}\"",
  }
  $ip_chunk = $ip ? {
    undef   => '',
    default => "ip=\"${ip}\"",
  }
  $password_chunk = $password ? {
    undef   => '',
    default => "password=\"${password}\"",
  }
  $password_script_chunk = $password_script ? {
    undef   => '',
    default => "password_script=\"${password_script}\"",
  }
  $verbose_chunk = $verbose ? {
    undef   => '',
    default => "verbose=\"${verbose}\"",
  }
  $debug_chunk = $debug ? {
    undef   => '',
    default => "debug=\"${debug}\"",
  }
  $debug_file_chunk = $debug_file ? {
    undef   => '',
    default => "debug_file=\"${debug_file}\"",
  }
  $power_wait_chunk = $power_wait ? {
    undef   => '',
    default => "power_wait=\"${power_wait}\"",
  }
  $login_timeout_chunk = $login_timeout ? {
    undef   => '',
    default => "login_timeout=\"${login_timeout}\"",
  }
  $power_timeout_chunk = $power_timeout ? {
    undef   => '',
    default => "power_timeout=\"${power_timeout}\"",
  }
  $delay_chunk = $delay ? {
    undef   => '',
    default => "delay=\"${delay}\"",
  }
  $shell_timeout_chunk = $shell_timeout ? {
    undef   => '',
    default => "shell_timeout=\"${shell_timeout}\"",
  }
  $amttool_path_chunk = $amttool_path ? {
    undef   => '',
    default => "amttool_path=\"${amttool_path}\"",
  }
  $port_as_ip_chunk = $port_as_ip ? {
    undef   => '',
    default => "port_as_ip=\"${port_as_ip}\"",
  }
  $retry_on_chunk = $retry_on ? {
    undef   => '',
    default => "retry_on=\"${retry_on}\"",
  }
  $sudo_chunk = $sudo ? {
    undef   => '',
    default => "sudo=\"${sudo}\"",
  }
  $use_sudo_chunk = $use_sudo ? {
    undef   => '',
    default => "use_sudo=\"${use_sudo}\"",
  }

  $pcmk_host_value_chunk = $pcmk_host_list ? {
    undef   => '$(/usr/sbin/crm_node -n)',
    default => $pcmk_host_list,
  }

  $meta_attr_value_chunk = $meta_attr ? {
    undef   => '',
    default => "meta ${meta_attr}",
  }

  # $title can be a mac address, remove the colons for pcmk resource name
  $safe_title = regsubst($title, ':', '', 'G')

  Exec<| title == 'wait-for-settle' |> -> Pcmk_stonith<||>

  $param_string = "${ipport_chunk} ${port_chunk} ${inet6_only_chunk} ${ipaddr_chunk} ${inet4_only_chunk} ${method_chunk} ${passwd_script_chunk} ${passwd_chunk} ${boot_option_chunk} ${action_chunk} ${plug_chunk} ${ip_chunk} ${password_chunk} ${password_script_chunk} ${verbose_chunk} ${debug_chunk} ${debug_file_chunk} ${power_wait_chunk} ${login_timeout_chunk} ${power_timeout_chunk} ${delay_chunk} ${shell_timeout_chunk} ${amttool_path_chunk} ${port_as_ip_chunk} ${retry_on_chunk} ${sudo_chunk} ${use_sudo_chunk}  op monitor interval=${interval} ${meta_attr_value_chunk}"


  pcmk_stonith { "stonith-fence_amt-${safe_title}":
    ensure           => $ensure,
    stonith_type     => 'fence_amt',
    pcmk_host_list   => $pcmk_host_value_chunk,
    pcs_param_string => $param_string,
    tries            => $tries,
    try_sleep        => $try_sleep,
  }
}
