# == Define: pacemaker::stonith::fence_scsi
#
# Module for managing Stonith for fence_scsi.
#
# WARNING: Generated by "rake generate_stonith", manual changes will
# be lost.
#
# === Parameters
#
# [*aptpl*]
#   Use APTPL flag for registrations
#
# [*devices*]
#   List of devices to be used for fencing action
#
# [*logfile*]
#   File to write error/debug messages
#
# [*delay*]
#   Wait X seconds before fencing is started
#
# [*key*]
#   Key value to be used for fencing action
#
# [*action*]
#   Fencing action
#
# [*nodename*]
#   Name of node
#
#  [*interval*]
#   Interval between tries.
#
# [*ensure*]
#   The desired state of the resource.
#
# [*tries*]
#   The numbre of tries.
#
# [*try_sleep*]
#   Time to sleep between tries.
#
# [*pcmk_host_list*]
#   List of Pacemaker hosts.
#
# === Dependencies
#  None
#
# === Authors
#
# Generated by rake generate_stonith task.
#
# === Copyright
#
# Copyright (C) 2016 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
define pacemaker::stonith::fence_scsi (
  $aptpl          = undef,
  $devices        = undef,
  $logfile        = undef,
  $delay          = undef,
  $key            = undef,
  $action         = undef,
  $nodename       = undef,

  $interval       = '60s',
  $ensure         = present,
  $pcmk_host_list = undef,

  $tries          = undef,
  $try_sleep      = undef,

) {
  $aptpl_chunk = $aptpl ? {
    undef   => '',
    default => "aptpl=\"${aptpl}\"",
  }
  $devices_chunk = $devices ? {
    undef   => '',
    default => "devices=\"${devices}\"",
  }
  $logfile_chunk = $logfile ? {
    undef   => '',
    default => "logfile=\"${logfile}\"",
  }
  $delay_chunk = $delay ? {
    undef   => '',
    default => "delay=\"${delay}\"",
  }
  $key_chunk = $key ? {
    undef   => '',
    default => "key=\"${key}\"",
  }
  $action_chunk = $action ? {
    undef   => '',
    default => "action=\"${action}\"",
  }
  $nodename_chunk = $nodename ? {
    undef   => '',
    default => "nodename=\"${nodename}\"",
  }

  $pcmk_host_value_chunk = $pcmk_host_list ? {
    undef   => '$(/usr/sbin/crm_node -n)',
    default => $pcmk_host_list,
  }

  # $title can be a mac address, remove the colons for pcmk resource name
  $safe_title = regsubst($title, ':', '', 'G')

  if($ensure == absent) {
    exec { "Delete stonith-fence_scsi-${safe_title}":
      command => "/usr/sbin/pcs stonith delete stonith-fence_scsi-${safe_title}",
      onlyif  => "/usr/sbin/pcs stonith show stonith-fence_scsi-${safe_title} > /dev/null 2>&1",
      require => Class['pacemaker::corosync'],
    }
  } else {
    package {
      'fence-agents-scsi': ensure => installed,
    } ->
    exec { "Create stonith-fence_scsi-${safe_title}":
      command   => "/usr/sbin/pcs stonith create stonith-fence_scsi-${safe_title} fence_scsi pcmk_host_list=\"${pcmk_host_value_chunk}\" ${aptpl_chunk} ${devices_chunk} ${logfile_chunk} ${delay_chunk} ${key_chunk} ${action_chunk} ${nodename_chunk}  op monitor interval=${interval}",
      unless    => "/usr/sbin/pcs stonith show stonith-fence_scsi-${safe_title} > /dev/null 2>&1",
      tries     => $tries,
      try_sleep => $try_sleep,
      require   => Class['pacemaker::corosync'],
    } ~>
    exec { "Add non-local constraint for stonith-fence_scsi-${safe_title}":
      command     => "/usr/sbin/pcs constraint location stonith-fence_scsi-${safe_title} avoids ${pcmk_host_value_chunk}",
      tries       => $tries,
      try_sleep   => $try_sleep,
      refreshonly => true,
    }
  }
}
