# Copyright (c) 2016 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from sahara import conductor as c
from sahara import context
from sahara.plugins import base as plugin_base


conductor = c.API


# Plugins ops

def get_plugins():
    return plugin_base.PLUGINS.get_plugins(serialized=True)


def get_plugin(plugin_name, version=None):
    return plugin_base.PLUGINS.serialize_plugin(plugin_name, version)


def update_plugin(plugin_name, values):
    return plugin_base.PLUGINS.update_plugin(plugin_name, values)


def construct_ngs_for_scaling(cluster, additional_node_groups):
    ctx = context.ctx()
    additional = {}
    for ng in additional_node_groups:
        count = ng['count']
        ng['count'] = 0
        ng_id = conductor.node_group_add(ctx, cluster, ng)
        additional.update({ng_id: count})
    return additional
