.\" dpkg manual page - dpkg-architecture(1)
.\"
.\" Copyright © 2005 Marcus Brinkmann <brinkmd@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2009-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-architecture 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOME
dpkg\-architecture \- imposta e determina l'architettura per la compilazione
dei pacchetti
.
.SH SINTASSI
\fBdpkg\-architecture\fP [\fIopzione\fP...] [\fIcomando\fP]
.PP
.
.SH DESCRIZIONE
\fBdpkg\-architecture\fP fornisce una funzionalità per determinare e impostare
l'architettura host e di compilazione per la compilazione dei pacchetti.
.PP
L'architettura di compilazione è sempre determinata da una chiamata esterna
a \fBdpkg\fP(1) e non può essere impostata dalla riga di comando.
.PP
È possibile specificare l'architettura ospite fornendo una o entrambe le
opzioni \fB\-\-host\-arch\fP e \fB\-\-host\-type\fP. Quella predefinita viene
determinata da una chiamata esterna a \fBgcc\fP(1) oppure, se entrambi \fBCC\fP e
gcc non sono disponibili, è la stessa dell'architettura di compilazione. È
sufficiente una di \fB\-\-host\-arch\fP e \fB\-\-host\-type\fP, il valore dell'altra
viene impostato da un valore predefinito utilizzabile. In effetti è spesso
meglio specificarne una sola, dato che \fBdpkg\-architecture\fP dà un
avvertimento se la scelta non corrisponde al valore predefinito.
.
.SH COMANDI
.TP 
\fB\-l\fP, \fB\-\-list\fP
Stampa le variabili d'ambiente, una per riga, nel formato
\fIVARIABILE=valore\fP. Questa è l'azione predefinita.
.TP 
\fB\-e\fP, \fB\-\-equal\fP \fIarchitettura\fP
Controlla l'uguaglianza dell'architettura (a partire da dpkg
1.13.13). Confronta l'architettura Debian ospite attuale o specificata con
\fIarchitettura\fP, per verificare se sono uguali. Questa azione non espande
l'espressione jolly per l'architettura. Il comando termina con uno stato di
uscita di 0 se corrispondono e 1 altrimenti.

.TP 
\fB\-i\fP, \fB\-\-is\fP \fIespressionejolly\-architettura\fP
Controlla l'identità dell'architettura (a partire da dpkg
1.13.13). Confronta l'architettura Debian ospite attuale o specificata con
\fIespressionejolly\-architettura\fP dopo aver fatto l'espansione
dell'espressione jolly per l'architettura, per verificare se
corrispondono. Il comando termina con uno stato di uscita di 0 se
corrispondono e 1 altrimenti.
.TP 
\fB\-q\fP, \fB\-\-query\fP \fInome\-variabile\fP
Stampa il valore di una singola variabile.
.TP 
\fB\-s\fP, \fB\-\-print\-set\fP
Stampa un comando di esportazione. Può essere usata per impostare le
variabili d'ambiente usando eval.
.TP 
\fB\-u\fP, \fB\-\-print\-unset\fP
Stampa un comando simile a \fB\-\-print\-unset\fP ma per deimpostare tutte le
variabili.
.TP 
\fB\-c\fP, \fB\-\-command\fP \fIcomando\fP
Esegue un \fIcomando\fP in un ambiente che ha tutte le variabili impostate al
valore determinato.
.TP 
\fB\-L\fP, \fB\-\-list\-known\fP
Stampa un elenco di nomi di architettura validi. Eventualmente ristretto da
una o più delle opzioni di corrispondenza \fB\-\-match\-wildcard\fP,
\fB\-\-match\-bits\fP o \fB\-\-match\-endian\fP (a partire da dpkg 1.17.14).
.TP 
\fB\-?\fP, \fB\-\-help\fP
Mostra il messaggio sull'uso ed esce.
.TP 
\fB\-\-version\fP
Mostra la versione ed esce.
.
.SH OPZIONI
.TP 
\fB\-a\fP, \fB\-\-host\-arch\fP \fIarchitettura\fP
Imposta l'architettura host Debian.
.TP 
\fB\-t\fP, \fB\-\-host\-type\fP \fItipo\-sistema\-gnu\fP
Imposta il tipo di sistema GNU ospite.
.TP 
\fB\-A\fP, \fB\-\-target\-arch\fP \fIarchitettura\fP
Set the target Debian architecture (since dpkg 1.17.14).
.TP 
\fB\-T\fP, \fB\-\-target\-type\fP \fItipo\-sistema\-gnu\fP
Set the target GNU system type (since dpkg 1.17.14).
.TP 
\fB\-W\fP, \fB\-\-match\-wildcard\fP \fIespressionejolly\-architettura\fP
Limita le architetture elencate da \fB\-\-list\-known\fP a quelle che
corrispondono alla espressione jolly specificata per l'architettura (a
partire da dpkg 1.17.14).
.TP 
\fB\-B\fP, \fB\-\-match\-bits\fP \fIbit\-architettura\fP
Limita le architetture elencate da \fB\-\-list\-known\fP a quelle con i bit CPU
specificati (a partire da dpkg 1.17.14). O \fB32\fP o \fB64\fP.
.TP 
\fB\-E\fP, \fB\-\-match\-endian\fP \fIendian\-architettura\fP
Limita le architetture elencate da \fB\-\-list\-known\fP a quelle con la modalità
endian specificata (a partire da dpkg 1.17.14). O \fBlittle\fP o \fBbig\fP.
.TP 
\fB\-f\fP, \fB\-\-force\fP
I valori impostati da variabili d'ambiente esistenti con nomi uguali a
quelli usati dagli script vengono rispettati (cioè usati da
\fBdpkg\-architecture\fP), tranne se viene usata questa opzione. Ciò permette
all'utente di sovrascrivere un valore anche quando la chiamata a
\fBdpkg\-architecture\fP è nascosta in qualche altro script (per esempio
\fBdpkg\-buildpackage\fP(1)).
.
.SH TERMINOLOGIA
.IP "macchina di compilazione" 4
La macchina usata per creare il pacchetto.
.IP "macchina ospite" 4
La macchina per cui è compilato il pacchetto.
.IP "macchina di destinazione" 4
The machine the compiler is building for.  This is only needed when building
a cross\-toolchain, one that will be built on the build architecture, to be
run on the host architecture, and to build code for the target architecture.
.IP "architettura Debian" 4
La stringa dell'architettura Debian che specifica l'albero binario
nell'archivio FTP. Esempi: i386, sparc, hurd\-i386.
.IP "Debian architecture tuple" 4
A Debian architecture tuple is the fully qualified architecture with all its
components spelled out.  This differs with Debian architectures in that at
least the \fIcpu\fP component does not embed the \fIabi\fP.  The current tuple has
the form \fIabi\fP\-\fIlibc\fP\-\fIos\fP\-\fIcpu\fP.  Examples: base\-gnu\-linux\-amd64,
eabihf\-musl\-linux\-arm.
.IP "Debian architecture wildcard" 4
A Debian architecture wildcard is a special architecture string that will
match any real architecture being part of it.  The general form is a Debian
architecture tuple with four or less elements, and with at least one of them
being \fBany\fP.  Missing elements of the tuple are prefixed implicitly as
\fBany\fP, and thus the following pairs are equivalent:
.nf
    \fBany\fP\-\fBany\fP\-\fBany\fP\-\fBany\fP = \fBany\fP
    \fBany\fP\-\fBany\fP\-\fIos\fP\-\fBany\fP = \fIos\fP\-\fBany\fP
    \fBany\fP\-\fIlibc\fP\-\fBany\fP\-\fBany\fP = \fIlibc\fP\-\fBany\fP\-\fBany\fP
.fi
Examples: linux\-any, any\-i386, hurd\-any, eabi\-any\-any\-arm, musl\-any\-any.
.IP "tipo di sistema GNU" 4
An architecture specification string consisting of two parts separated by a
hyphen: cpu and system.  Examples: i586\-linux\-gnu, sparc\-linux\-gnu,
i686\-gnu, x86_64\-netbsd.
.IP "multiarch triplet" 4
The clarified GNU system type, used for filesystem paths.  This triplet does
not change even when the baseline ISA gets bumped, so that the resulting
paths are stable over time.  The only current difference with the GNU system
type is that the CPU part for i386 based systems is always i386.  Examples:
i386\-linux\-gnu, x86_64\-linux\-gnu.  Example paths:
/lib/powerpc64le\-linux\-gnu/, /usr/lib/i386\-kfreebsd\-gnu/.
.
.SH VARIABILI
\fBdpkg\-architecture\fP imposta le seguenti variabili:
.IP \fBDEB_BUILD_ARCH\fP 4
L'architettura Debian della macchina di compilazione.
.IP \fBDEB_BUILD_ARCH_ABI\fP 4
The Debian abi name of the build machine (since dpkg 1.18.11).
.IP \fBDEB_BUILD_ARCH_LIBC\fP 4
The Debian libc name of the build machine (since dpkg 1.18.11).
.IP \fBDEB_BUILD_ARCH_OS\fP 4
Il nome di sistema Debian della macchina di compilazione (a partire da dpkg
1.13.2).
.IP \fBDEB_BUILD_ARCH_CPU\fP 4
Il nome Debian per la CPU della macchina di compilazione (a partire da dpkg
1.13.2).
.IP \fBDEB_BUILD_ARCH_BITS\fP 4
La dimensione del puntatore della macchina di compilazione (in bit; a
partire da dpkg 1.15.4).
.IP \fBDEB_BUILD_ARCH_ENDIAN\fP 4
La modalità endian della macchina di compilazione (little o big; a partire
da dpkg 1.15.4).
.IP \fBDEB_BUILD_GNU_CPU\fP 4
La parte CPU di \fBDEB_BUILD_GNU_TYPE\fP.
.IP \fBDEB_BUILD_GNU_SYSTEM\fP 4
La parte sistema di \fBDEB_BUILD_GNU_TYPE\fP.
.IP \fBDEB_BUILD_GNU_TYPE\fP 4
Il tipo di sistema GNU della macchina di compilazione.
.IP \fBDEB_BUILD_MULTIARCH\fP 4
Il tipo di sistema GNU chiarito della macchina di compilazione usato per i
percorsi del file system (a partire da dpkg 1.16.0).
.IP \fBDEB_HOST_ARCH\fP 4
L'architettura Debian della macchina ospite.
.IP \fBDEB_HOST_ARCH_ABI\fP 4
The Debian abi name of the host machine (since dpkg 1.18.11).
.IP \fBDEB_HOST_ARCH_LIBC\fP 4
The Debian libc name of the host machine (since dpkg 1.18.11).
.IP \fBDEB_HOST_ARCH_OS\fP 4
Il nome di sistema Debian della macchina ospite (a partire da dpkg 1.13.2).
.IP \fBDEB_HOST_ARCH_CPU\fP 4
Il nome Debian per la CPU della macchina host (a partire da dpkg 1.13.2).
.IP \fBDEB_HOST_ARCH_BITS\fP 4
La dimensione del puntatore della macchina ospite (in bit; a partire da dpkg
1.15.4).
.IP \fBDEB_HOST_ARCH_ENDIAN\fP 4
La modalità endian della macchina ospite (little o big; a partire da dpkg
1.15.4).
.IP \fBDEB_HOST_GNU_CPU\fP 4
La parte CPU di \fBDEB_HOST_GNU_TYPE\fP.
.IP \fBDEB_HOST_GNU_SYSTEM\fP 4
La parte sistema di \fBDEB_HOST_GNU_TYPE\fP.
.IP \fBDEB_HOST_GNU_TYPE\fP 4
Il tipo di sistema GNU della macchina ospite.
.IP \fBDEB_HOST_MULTIARCH\fP 4
Il tipo di sistema GNU chiarito della macchina ospite usato per i percorsi
del file system (a partire da dpkg 1.16.0).
.IP \fBDEB_TARGET_ARCH\fP 4
L'architettura Debian della macchina di destinazione (a partire da dpkg
1.17.14).
.IP \fBDEB_TARGET_ARCH_ABI\fP 4
The Debian abi name of the target machine (since dpkg 1.18.11).
.IP \fBDEB_TARGET_ARCH_LIBC\fP 4
The Debian libc name of the target machine (since dpkg 1.18.11).
.IP \fBDEB_TARGET_ARCH_OS\fP 4
Il nome di sistema Debian della macchina di destinazione (a partire da dpkg
1.17.14).
.IP \fBDEB_TARGET_ARCH_CPU\fP 4
Il nome Debian per la CPU della macchina di destinazione (a partire da dpkg
1.17.14).
.IP \fBDEB_TARGET_ARCH_BITS\fP 4
La dimensione del puntatore della macchina di destinazione (in bit; a
partire da dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_ENDIAN\fP 4
La modalità endian della macchina di destinazione (little o big; a partire
da dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_CPU\fP 4
La parte CPU di \fBDEB_TARGET_GNU_TYPE\fP (a partie da dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_SYSTEM\fP 4
La parte sistema di \fBDEB_TARGET_GNU_TYPE\fP (a partire da dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_TYPE\fP 4
Il tipo di sistema GNU della macchina di destinazione (a partire da dpkg
1.17.14).
.IP \fBDEB_TARGET_MULTIARCH\fP 4
Il tipo di sistema GNU chiarito della macchina di destinazione usato per i
percorsi del file system (a partire da dpkg 1.17.14).
.
.SH FILE
.SS "Tabelle delle architetture"
All these files have to be present for \fBdpkg\-architecture\fP to work. Their
location can be overridden at runtime with the environment variable
\fBDPKG_DATADIR\fP.  These tables contain a format \fBVersion\fP pseudo\-field on
their first line to mark their format, so that parsers can check if they
understand it, such as "# Version=1.0".
.TP 
\fI%PKGDATADIR%/cputable\fP
Table of known CPU names and mapping to their GNU name.  Format version 1.0
(since dpkg 1.13.2).
.TP 
\fI%PKGDATADIR%/ostable\fP
Table of known operating system names and mapping to their GNU name.  Format
version 2.0 (since dpkg 1.18.11).
.TP 
\fI%PKGDATADIR%/tupletable\fP
Mapping between Debian architecture tuples and Debian architecture names.
Format version 1.0 (since dpkg 1.18.11).
.TP 
\fI%PKGDATADIR%/abitable\fP
Table of Debian architecture ABI attribute overrides.  Format version 2.0
(since dpkg 1.18.11).
.SS "Supporto per pacchettizzazione"
.TP 
\fI%PKGDATADIR%/architecture.mk\fP
Frammento di makefile che imposta ed esporta in modo corretto tutte le
variabili prodotte in output da \fBdpkg\-architecture\fP (a partire da dpkg
1.16.1).
.
.SH ESEMPI
\fBdpkg\-buildpackage\fP accetta l'opzione \fB\-a\fP e la passa a
\fBdpkg\-architecture\fP. Altri esempi:
.IP
CC=i386\-gnu\-gcc dpkg\-architecture \-c debian/rules build
.IP
eval \`dpkg\-architecture \-u\`
.PP
Controlla se l'architettura ospite corrente o specificata è uguale ad
un'architettura:
.IP
dpkg\-architecture \-elinux\-alpha
.IP
dpkg\-architecture \-amips \-elinux\-mips
.PP
Controlla se l'architettura ospite corrente o specificata è un sistema
Linux:
.IP
dpkg\-architecture \-ilinux\-any
.IP
dpkg\-architecture \-ai386 \-ilinux\-any
.
.SS "Uso in debian/rules"
Le variabili d'ambiente impostate da \fBdpkg\-architecture\fP vengono passate a
\fIdebian/rules\fP come variabili make (vedere la documentazione di
make). Tuttavia non si deve fare affidamento su di esse, dato che ciò rende
non funzionanti le invocazioni manuali dello script. Le si dovrebbe invece
inizializzare sempre usando \fBdpkg\-architecture\fP con l'opzione \fB\-q\fP. Ecco
alcuni esempi, che mostrano anche come migliorare il supporto per la
cross\-compilazione nei propri pacchetti:
.PP
Recuperare il tipo di sistema GNU e passarlo a ./configure:
.PP
.RS 4
.nf
DEB_BUILD_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_HOST_GNU_TYPE)
[...]
ifeq ($(DEB_BUILD_GNU_TYPE), $(DEB_HOST_GNU_TYPE))
  confflags += \-\-build=$(DEB_HOST_GNU_TYPE)
else
  confflags += \-\-build=$(DEB_BUILD_GNU_TYPE) \e
               \-\-host=$(DEB_HOST_GNU_TYPE)
endif
[...]
\&./configure $(confflags)
.fi
.RE
.PP
Fare qualcosa solo per un'architettura specifica:
.PP
.RS 4
.nf
DEB_HOST_ARCH ?= $(shell dpkg\-architecture \-qDEB_HOST_ARCH)

ifeq ($(DEB_HOST_ARCH),alpha)
  [...]
endif
.fi
.RE
.PP
oppure se è necessario solo controllare il tipo di CPU o sistema operativo,
usare le variabili \fBDEB_HOST_ARCH_CPU\fP o \fBDEB_HOST_ARCH_OS\fP.
.PP
Notare che ci si può anche appoggiare su un frammento di Makefile esterno
per impostare correttamente tutte le variabili che possono essere fornite da
\fBdpkg\-architecture\fP.
.PP
.RS 4
.nf
include %PKGDATADIR%/architecture.mk

ifeq ($(DEB_HOST_ARCH),alpha)
  [...]
endif
.fi
.RE
.PP
In ogni caso non si dovrebbe mai usare \fBdpkg \-\-print\-architecture\fP per
ottenere informazioni sull'architettura durante la compilazione di un
pacchetto.
.
.SH NOTE
Tutti i nomi lunghi di comandi e opzioni disponibili solo a partire da dpkg
1.17.17.
.
.SH "VEDERE ANCHE"
\fBdpkg\-buildpackage\fP(1), \fBdpkg\-cross\fP(1).
