# Release notes

## 2025.1.0-84

- This change applies a fix to the StatefulSet template of the MariaDB chart,
  ensuring that the hash for the exporter secrets is correctly included. This
  is necessary for the proper functioning of the exporter component in the
  MariaDB deployment.
- This change disables TLS for the Prometheus MySQL exporter sidecar container in the MariaDB StatefulSet.

### New Features

- Update apparmor values to use security_context instead of annotations.
- Add support for runtimeClassName and priorityClassName

### Bug Fixes

- In order to fix this issue, the TLS configuration for the Prometheus MySQL exporter sidecar container has been updated to disable TLS. This allows the exporter to connect to the MariaDB database without requiring a CA certificate.

## 2025.1.0

- 0.1.0 Initial Chart
- 0.1.1 Change helm-toolkit dependency version to ">= 0.1.0"
- 0.1.2 mariadb security best practice fixes
- 0.1.3 Fix MariaDB backup script
- 0.1.4 Unpin images built with osh-images
- 0.1.5 Update to container image repo k8s.gcr.io
- 0.1.6 Change Issuer to ClusterIssuer
- 0.1.7 Revert - Change Issuer to ClusterIssuer
- 0.1.8 Change Issuer to ClusterIssuer with logic in place to support cert-manager versioning
- 0.1.9 Uplift Mariadb-ingress to 0.42.0
- 0.1.10 Rename mariadb backup identities
- 0.1.11 Disable mariadb mysql history client logging
- 0.1.12 Set strict permission on mariadb data dir
- 0.1.13 Fix race condition for grastate.dat
- 0.1.14 Update mysqld-exporter image to v0.12.1
- 0.2.0 Uplift mariadb version and ubuntu release
- 0.2.1 Prevent potential splitbrain issue if cluster is in reboot state
- 0.2.2 remove deprecated svc annotation tolerate-unready-endpoints
- 0.2.3 Remove panko residue
- 0.2.4 Use full image ref for docker official images
- 0.2.5 Added helm hook for post-install and post-upgrade in prometheus exporter job.
- 0.2.6 Update log format stream for mariadb
- 0.2.7 add ingress resources
- 0.2.8 Helm 3 - Fix Job labels
- 0.2.9 Update htk requirements
- 0.2.10 Fix Python exceptions
- 0.2.11 Enhance mariadb backup
- 0.2.12 Remove set -x
- 0.2.13 Adjust readiness.sh in single node and no replication case
- 0.2.14 Fix comparison value
- 0.2.15 Updated naming for subchart compatibility
- 0.2.16 Revert naming for subchart compatibility
- 0.2.17 Enable taint toleration for Openstack services jobs
- 0.2.18 Updated naming for subchart compatibility
- 0.2.19 Update default image value to Wallaby
- 0.2.20 Migrated CronJob resource to batch/v1 API version & PodDisruptionBudget to policy/v1; Uplift Mariadb-ingress to 1.1.3
- 0.2.21 Fix mysql exporter user privileges
- 0.2.22 Fix ingress cluster role privileges
- 0.2.23 Fix backup script by ignoring sys database for MariaDB 10.6 compartibility
- 0.2.24 Uplift Mariadb-ingress to 1.2.0
- 0.2.25 Add liveness probe to restart a pod that got stuck in a transfer wsrep_local_state_comment
- 0.2.26 Added OCI registry authentication
- 0.2.27 Fix broken helmrelease for helmv3
- 0.2.28 Added verify_databases_backup_in_directory function implementation
- 0.2.29 Uplift Mariadb-ingress to 1.5.1
- 0.2.30 Replace node-role.kubernetes.io/master with control-plane
- 0.2.31 Update kubernetes registry to registry.k8s.io
- 0.2.32 Prevent liveness probe from killing pods during SST
- 0.2.33 Add 2023.1 Ubuntu Focal overrides
- 0.2.34 Uplift ingress controller image to 1.8.2
- 0.2.35 Update apparmor override
- 0.2.36 Added staggered backups support
- 0.2.37 Backups verification improvements
- 0.2.38 Added throttling remote backups
- 0.2.39 Template changes for image 1.9 compatibility
- 0.2.40 Start.py allows to create mariadb-service-primary service and endpoint
- 0.2.41 Switch to primary service instead of ingress by default
- 0.2.42 Use quay.io/airshipit/kubernetes-entrypoint:latest-ubuntu_focal by default
- 0.2.43 Add 2024.1 Ubuntu Jammy overrides
- 0.2.44 Uplift ingress controller image to 1.11.2
- 0.2.45 Add mariadb controller support
- 0.2.46 Avoid using cluster endpoints
- 0.2.47 Deploy exporter as sidecar
- 0.2.48 Switch to mariadb controller deployment
- 0.2.49 Remove ingress deployment
- 0.2.50 Add cluster-wait job
- 0.2.51 Add 2024.2 overrides
- 0.2.52 Added SSL support to cluster-wait job
- 0.2.53 Use constant for mysql binary name
- 0.2.54 Improve leader election on cold start
- 0.2.55 Improve python3 compatibility
- 0.2.56 Stop running threads on sigkill
- 0.2.57 Remove useless retries on conflicts during cm update
- 0.2.58 Prevent TypeError in get_active_endpoint function
- 0.2.59 Give more time on resolving configmap update conflicts
- 0.2.60 Refactor liveness/readiness probes
- 0.2.61 Avoid using deprecated isAlive()
- 0.2.62 Implement mariadb upgrade during start
- 0.2.63 Use service ip for endpoint discovery
- 0.2.64 Add terminationGracePeriodSeconds
- 0.2.65 Allow to use default storage class
- 0.2.66 Add probes for exporter
- 0.2.67 Update Chart.yaml apiVersion to v2
- 2024.2.0 Update version to align with the Openstack release cycle

## 2024.2.0

Before 2024.2.0 all the OpenStack-Helm charts were versioned independently.
Here we provide all the release notes for the chart for all versions before 2024.2.0.
