# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright (c) 2012 Red Hat, Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from sqlalchemy import Index, MetaData, Table


def upgrade(migrate_engine):
    meta = MetaData()
    meta.bind = migrate_engine

    # Based on migration_get_by_instance_and_status
    # from: nova/db/sqlalchemy/api.py
    t = Table('migrations', meta, autoload=True)
    i = Index('migrations_instance_uuid_and_status_idx', t.c.deleted,
            t.c.instance_uuid, t.c.status)
    i.create(migrate_engine)


def downgrade(migrate_engine):
    meta = MetaData()
    meta.bind = migrate_engine

    t = Table('migrations', meta, autoload=True)
    i = Index('migrations_instance_uuid_and_status_idx', t.c.deleted,
            t.c.instance_uuid, t.c.status)
    i.drop(migrate_engine)
