#!/bin/sh

SOURCEDIR=source/api

if [ ! -d ${SOURCEDIR} ] ; then
    mkdir -p ${SOURCEDIR}
fi

for x in `./find_autodoc_modules.sh`;
do
  echo "Generating ${SOURCEDIR}/${x}.rst"
  echo "${SOURCEDIR}/${x}.rst" >> .autogenerated 
  ( cat <<EOF
The :mod:\`${x}\` Module
==============================================================================
.. automodule:: ${x}
  :members:
  :undoc-members:
  :show-inheritance:
EOF
) > ${SOURCEDIR}/${x}.rst

done

if [ ! -f ${SOURCEDIR}/autoindex.rst ] ; then

    cat > ${SOURCEDIR}/autoindex.rst <<EOF 
.. toctree::
   :maxdepth: 1

EOF
    for f in `cat .autogenerated | sort` ; do
        relative=`echo ${f} | sed -e 's$^'${SOURCEDIR}'/$$'`
        echo "   ${relative}" >> ${SOURCEDIR}/autoindex.rst
    done

    echo ${SOURCEDIR}/autoindex.rst >> .autogenerated
fi
