# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2011 OpenStack LLC.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import json

import webob


def webob_factory(url):
    """Factory for removing duplicate webob code from tests"""

    base_url = url

    def web_request(url, method=None, body=None):
        req = webob.Request.blank("%s%s" % (base_url, url))
        if method:
            req.method = method
        if body:
            req.body = json.dumps(body)
        return req
    return web_request
