# Copyright 2015 IBM Corp.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os
import pprint

from oslo_versionedobjects import base as obj_base
from oslo_versionedobjects import fixture

from neutron.common import utils
from neutron import objects
from neutron.tests import base as test_base


# NOTE: The hashes in this list should only be changed if they come with a
# corresponding version bump in the affected objects. Please keep the list in
# alphabetic order.
object_data = {
    '_DefaultSecurityGroup': '1.0-971520cb2e0ec06d747885a0cf78347f',
    'AddressScope': '1.0-25560799db384acfe1549634959a82b4',
    'Agent': '1.0-7a8de4fedc7d318e7b6883b9747d1adb',
    'AllowedAddressPair': '1.0-9f9186b6f952fbf31d257b0458b852c0',
    'DistributedPortBinding': '1.0-4df058ae1aeae3ae1c15b8f6a4c692d9',
    'DNSNameServer': '1.0-bf87a85327e2d812d1666ede99d9918b',
    'ExtraDhcpOpt': '1.0-632f689cbeb36328995a7aed1d0a78d3',
    'FloatingIPDNS': '1.0-ee3db848500fa1825235f701828c06d5',
    'IPAllocation': '1.0-47251b4c6d45c3b5feb0297fe5c461f2',
    'IPAllocationPool': '1.0-371016a6480ed0b4299319cb46d9215d',
    'Network': '1.0-f2f6308f79731a767b92b26b0f4f3849',
    'NetworkDNSDomain': '1.0-420db7910294608534c1e2e30d6d8319',
    'NetworkPortSecurity': '1.0-b30802391a87945ee9c07582b4ff95e3',
    'NetworkSegment': '1.0-40707ef6bd9a0bf095038158d995cc7d',
    'Port': '1.0-638f6b09a3809ebd8b2b46293f56871b',
    'PortBinding': '1.0-f5d3048bec0ac58f08a758427581dff9',
    'PortBindingLevel': '1.0-de66a4c61a083b8f34319fa9dde5b060',
    'PortDNS': '1.0-201cf6d057fde75539c3d1f2bbf05902',
    'PortSecurity': '1.0-b30802391a87945ee9c07582b4ff95e3',
    'ProviderResourceAssociation': '1.0-05ab2d5a3017e5ce9dd381328f285f34',
    'ProvisioningBlock': '1.0-c19d6d05bfa8143533471c1296066125',
    'QosBandwidthLimitRule': '1.2-4e44a8f5c2895ab1278399f87b40a13d',
    'QosDscpMarkingRule': '1.2-0313c6554b34fd10c753cb63d638256c',
    'QosMinimumBandwidthRule': '1.2-314c3419f4799067cc31cc319080adff',
    'QosRuleType': '1.2-e6fd08fcca152c339cbd5e9b94b1b8e7',
    'QosPolicy': '1.3-2eb3494f990acae59cb51381e7f99443',
    'Route': '1.0-a9883a63b416126f9e345523ec09483b',
    'RouterExtraAttributes': '1.0-ef8d61ae2864f0ec9af0ab7939cab318',
    'RouterRoute': '1.0-07fc5337c801fb8c6ccfbcc5afb45907',
    'SecurityGroup': '1.0-e26b90c409b31fd2e3c6fcec402ac0b9',
    'SecurityGroupRule': '1.0-e9b8dace9d48b936c62ad40fe1f339d5',
    'SegmentHostMapping': '1.0-521597cf82ead26217c3bd10738f00f0',
    'Subnet': '1.0-9c19023a61b42d29fbf3766df380e5b7',
    'SubnetPool': '1.0-e8300bfbc4762cc88a7f6205b52da2f8',
    'SubnetPoolPrefix': '1.0-13c15144135eb869faa4a76dc3ee3b6c',
    'SubnetServiceType': '1.0-05ae4cdb2a9026a697b143926a1add8c',
    'SubPort': '1.0-72c8471068db1f0491b5480fe49b52bb',
    'Trunk': '1.0-80ebebb57f2b0dbb510f84d91421ed10',
    'VlanAllocation': '1.0-72636c1b7d5c8eef987bd09666e64f3e',
}


class TestObjectVersions(test_base.BaseTestCase):

    def setUp(self):
        super(TestObjectVersions, self).setUp()
        # NOTE(ihrachys): seed registry with all objects under neutron.objects
        # before validating the hashes
        utils.import_modules_recursively(os.path.dirname(objects.__file__))

    def test_versions(self):
        checker = fixture.ObjectVersionChecker(
            obj_base.VersionedObjectRegistry.obj_classes())
        fingerprints = checker.get_hashes()

        if os.getenv('GENERATE_HASHES'):
            with open('object_hashes.txt', 'w') as hashes_file:
                hashes_file.write(pprint.pformat(fingerprints))

        expected, actual = checker.test_hashes(object_data)
        self.assertEqual(expected, actual,
                         'Some objects have changed; please make sure the '
                         'versions have been bumped, and then update their '
                         'hashes in the object_data map in this test module.')
