# vim: tabstop=4 shiftwidth=4 softtabstop=4

#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from django.conf import settings
from django.test.utils import override_settings

from openstack_dashboard import api
from openstack_dashboard.test import helpers as test


class HeatApiTests(test.APITestCase):
    def test_stack_list(self):
        api_stacks = self.stacks.list()

        heatclient = self.stub_heatclient()
        heatclient.stacks = self.mox.CreateMockAnything()
        heatclient.stacks.list().AndReturn(iter(api_stacks))
        self.mox.ReplayAll()

        stacks = api.heat.stacks_list(self.request)
        self.assertItemsEqual(stacks, api_stacks)
