/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.persistence.hibernate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDimensionDb;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.thresh.domain.model.AlarmDefinition;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class AlarmDefinitionSqlImpl
implements AlarmDefinitionDAO {
    private final SessionFactory sessionFactory;

    @Inject
    public AlarmDefinitionSqlImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlarmDefinition> listAll() {
        ArrayList alarmDefinitions = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            List alarmDefDbList = session.createCriteria(AlarmDefinitionDb.class).add(Restrictions.isNull((String)"deletedAt")).addOrder(Order.asc((String)"createdAt")).setReadOnly(true).list();
            if (alarmDefDbList != null) {
                alarmDefinitions = Lists.newArrayListWithExpectedSize((int)alarmDefDbList.size());
                for (AlarmDefinitionDb alarmDefDb : alarmDefDbList) {
                    Collection matchBy = alarmDefDb.getMatchByAsCollection();
                    boolean actionEnable = alarmDefDb.isActionsEnabled();
                    alarmDefinitions.add(new AlarmDefinition((String)((Object)alarmDefDb.getId()), alarmDefDb.getTenantId(), alarmDefDb.getName(), alarmDefDb.getDescription(), AlarmExpression.of((String)alarmDefDb.getExpression()), alarmDefDb.getSeverity().name(), actionEnable, this.findSubExpressions(session, (String)((Object)alarmDefDb.getId())), matchBy.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)matchBy)));
                    session.evict((Object)alarmDefDb);
                }
            }
            List<Object> list = alarmDefinitions == null ? Collections.emptyList() : alarmDefinitions;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlarmDefinition findById(String id) {
        AlarmDefinition alarmDefinition = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            AlarmDefinitionDb alarmDefDb = (AlarmDefinitionDb)session.get(AlarmDefinitionDb.class, (Serializable)((Object)id));
            if (alarmDefDb != null) {
                Collection matchBy = alarmDefDb.getMatchByAsCollection();
                boolean actionEnabled = alarmDefDb.isActionsEnabled();
                AlarmExpression expression = AlarmExpression.of((String)alarmDefDb.getExpression());
                alarmDefinition = new AlarmDefinition((String)((Object)alarmDefDb.getId()), alarmDefDb.getTenantId(), alarmDefDb.getName(), alarmDefDb.getDescription(), expression, alarmDefDb.getSeverity().name(), actionEnabled, this.findSubExpressions(session, id), matchBy.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)matchBy));
            }
            AlarmDefinition alarmDefinition2 = alarmDefinition;
            return alarmDefinition2;
        }
    }

    private List<SubExpression> findSubExpressions(Session session, String alarmDefId) {
        Object id;
        ArrayList subExpressions = Lists.newArrayList();
        HashMap dimensionMap = Maps.newHashMap();
        DetachedCriteria subAlarmDefinitionCriteria = DetachedCriteria.forClass(SubAlarmDefinitionDb.class, (String)"sad").createAlias("alarmDefinition", "ad").add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"sad.alarmDefinition.id", (String)"ad.id"), Restrictions.eq((String)"sad.alarmDefinition.id", (Object)alarmDefId)})).addOrder(Order.asc((String)"sad.id")).setProjection((Projection)Projections.property((String)"sad.id"));
        ScrollableResults subAlarmDefinitionDimensionResult = session.createCriteria(SubAlarmDefinitionDimensionDb.class).add(Property.forName((String)"subAlarmDefinitionDimensionId.subExpression.id").in(subAlarmDefinitionCriteria)).setReadOnly(true).scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResults subAlarmDefinitionResult = session.getNamedQuery("SubAlarmDefinition.byAlarmDefinitionId").setString("id", alarmDefId).setReadOnly(true).scroll(ScrollMode.FORWARD_ONLY);
        while (subAlarmDefinitionDimensionResult.next()) {
            SubAlarmDefinitionDimensionDb dim = (SubAlarmDefinitionDimensionDb)subAlarmDefinitionDimensionResult.get()[0];
            id = dim.getSubAlarmDefinitionDimensionId();
            String subAlarmId = (String)((Object)session.getIdentifier((Object)id.getSubExpression()));
            String name = id.getDimensionName();
            String value = dim.getValue();
            if (!dimensionMap.containsKey(subAlarmId)) {
                dimensionMap.put(subAlarmId, Maps.newTreeMap());
            }
            ((Map)dimensionMap.get(subAlarmId)).put(name, value);
            session.evict((Object)dim);
        }
        while (subAlarmDefinitionResult.next()) {
            SubAlarmDefinitionDb def = (SubAlarmDefinitionDb)subAlarmDefinitionResult.get()[0];
            id = (String)((Object)def.getId());
            AggregateFunction function = AggregateFunction.fromJson((String)def.getFunction());
            String metricName = def.getMetricName();
            AlarmOperator operator = AlarmOperator.fromJson((String)def.getOperator());
            Double threshold = def.getThreshold();
            Integer period = def.getPeriod();
            Integer periods = def.getPeriods();
            Boolean deterministic = def.isDeterministic();
            Map dimensions = (Map)dimensionMap.get(id);
            if (dimensions == null) {
                dimensions = Collections.emptyMap();
            }
            subExpressions.add(new SubExpression((String)id, new AlarmSubExpression(function, new MetricDefinition(metricName, dimensions), operator, threshold.doubleValue(), period.intValue(), periods.intValue(), deterministic.booleanValue())));
            session.evict((Object)def);
        }
        subAlarmDefinitionDimensionResult.close();
        subAlarmDefinitionResult.close();
        return subExpressions;
    }
}

