/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding.deserializer;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import monasca.common.model.event.AlarmDefinitionCreatedEvent;
import monasca.common.model.event.AlarmDefinitionDeletedEvent;
import monasca.common.model.event.AlarmDefinitionUpdatedEvent;
import monasca.common.model.event.AlarmDeletedEvent;
import monasca.common.model.event.AlarmUpdatedEvent;
import monasca.common.util.Serialization;
import monasca.thresh.utils.TupleDeserializer;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDeserializer
implements TupleDeserializer,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(EventDeserializer.class);
    private static final long serialVersionUID = -1306620481933667305L;
    private static final Fields FIELDS = new Fields(new String[]{"event"});

    @Override
    public List<List<?>> deserialize(byte[] tuple) {
        try {
            String tupleStr = new String(tuple, "UTF-8");
            return Collections.singletonList(Collections.singletonList(Serialization.fromJson((String)tupleStr)));
        }
        catch (Exception ex) {
            logger.error("Failed to parse event: " + new String(tuple), (Throwable)ex);
            return null;
        }
    }

    @Override
    public Fields getOutputFields() {
        return FIELDS;
    }

    static {
        Serialization.registerTarget(AlarmDefinitionUpdatedEvent.class);
        Serialization.registerTarget(AlarmDefinitionDeletedEvent.class);
        Serialization.registerTarget(AlarmDefinitionCreatedEvent.class);
        Serialization.registerTarget(AlarmUpdatedEvent.class);
        Serialization.registerTarget(AlarmDeletedEvent.class);
    }
}

