/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import monasca.common.configuration.KafkaProducerConfiguration;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.event.AlarmDefinitionUpdatedEvent;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.common.model.event.AlarmUpdatedEvent;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.util.Injector;
import monasca.common.util.Serialization;
import monasca.thresh.domain.model.Alarm;
import monasca.thresh.domain.model.AlarmDefinition;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.service.AlarmDAO;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import monasca.thresh.infrastructure.persistence.PersistenceModule;
import monasca.thresh.infrastructure.thresholding.AlarmEventForwarder;
import monasca.thresh.infrastructure.thresholding.DataSourceFactory;
import monasca.thresh.infrastructure.thresholding.ProducerModule;
import monasca.thresh.utils.Logging;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmThresholdingBolt
extends BaseRichBolt {
    private static final long serialVersionUID = -4126465124017857754L;
    private transient Logger logger;
    private DataSourceFactory dbConfig;
    private KafkaProducerConfiguration producerConfiguration;
    final Map<String, Alarm> alarms = new HashMap<String, Alarm>();
    final Map<String, AlarmDefinition> alarmDefinitions = new HashMap<String, AlarmDefinition>();
    private transient AlarmDAO alarmDAO;
    private transient AlarmDefinitionDAO alarmDefinitionDAO;
    private transient AlarmEventForwarder alarmEventForwarder;
    private OutputCollector collector;

    public AlarmThresholdingBolt(DataSourceFactory dbConfig, KafkaProducerConfiguration producerConfig) {
        this.dbConfig = dbConfig;
        this.producerConfiguration = producerConfig;
    }

    public AlarmThresholdingBolt(AlarmDAO alarmDAO, AlarmDefinitionDAO alarmDefinitionDAO, AlarmEventForwarder alarmEventForwarder) {
        this.alarmDAO = alarmDAO;
        this.alarmDefinitionDAO = alarmDefinitionDAO;
        this.alarmEventForwarder = alarmEventForwarder;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Tuple tuple) {
        this.logger.debug("tuple: {}", (Object)tuple);
        try {
            String eventType;
            if ("default".equals(tuple.getSourceStreamId())) {
                String alarmId = tuple.getString(0);
                Alarm alarm = this.getOrCreateAlarm(alarmId);
                if (alarm == null) {
                    return;
                }
                SubAlarm subAlarm = (SubAlarm)tuple.getValue(1);
                this.evaluateThreshold(alarm, subAlarm);
            } else if ("alarm-events".equals(tuple.getSourceStreamId())) {
                String eventType2 = tuple.getString(0);
                String alarmId = tuple.getString(1);
                if ("deleted".equals(eventType2)) {
                    this.handleAlarmDeleted(alarmId);
                } else if ("updated".equals(eventType2)) {
                    this.handleAlarmUpdated(alarmId, (AlarmUpdatedEvent)tuple.getValue(2));
                }
            } else if ("alarm-definition-events".equals(tuple.getSourceStreamId())) {
                String eventType3 = tuple.getString(0);
                if ("updated".equals(eventType3)) {
                    this.handle((AlarmDefinitionUpdatedEvent)tuple.getValue(1));
                }
            } else if ("metric-sub-alarm-events".equals(tuple.getSourceStreamId()) && "updated".equals(eventType = tuple.getString(0))) {
                this.handleAlarmSubExpressionUpdated((SubExpression)tuple.getValue(1), tuple.getString(2));
            }
        }
        catch (Exception e) {
            this.logger.error("Error processing tuple {}", (Object)tuple, (Object)e);
        }
        finally {
            this.collector.ack(tuple);
        }
    }

    private void handleAlarmSubExpressionUpdated(SubExpression value, String alarmDefinitionId) {
        int updated = 0;
        for (Alarm alarm : this.alarms.values()) {
            if (!alarm.getAlarmDefinitionId().equals(alarmDefinitionId)) continue;
            for (SubAlarm subAlarm : alarm.getSubAlarms()) {
                if (!subAlarm.getAlarmSubExpressionId().equals(value.getId())) continue;
                subAlarm.setExpression(value.getAlarmSubExpression());
                ++updated;
            }
        }
        this.logger.debug("Updated {} SubAlarms", (Object)updated);
    }

    private void handle(AlarmDefinitionUpdatedEvent event) {
        AlarmDefinition alarmDefinition = this.alarmDefinitions.get(event.alarmDefinitionId);
        if (alarmDefinition == null) {
            this.logger.debug("Update of AlarmDefinition {} skipped. Not in use by this bolt", (Object)event.alarmDefinitionId);
            return;
        }
        this.logger.info("Updating AlarmDefinition {}", (Object)event.alarmDefinitionId);
        alarmDefinition.setName(event.alarmName);
        alarmDefinition.setDescription(event.alarmDescription);
        alarmDefinition.setSeverity(event.severity);
        alarmDefinition.setActionsEnabled(event.alarmActionsEnabled);
        alarmDefinition.setExpression(event.alarmExpression);
        for (Map.Entry entry : event.changedSubExpressions.entrySet()) {
            if (alarmDefinition.updateSubExpression((String)entry.getKey(), (AlarmSubExpression)entry.getValue())) continue;
            this.logger.error("AlarmDefinition {}: Did not finding matching SubAlarmExpression id={} SubAlarmExpression{}", new Object[]{event.alarmDefinitionId, entry.getKey(), entry.getValue()});
        }
    }

    public void prepare(Map config, TopologyContext context, OutputCollector collector) {
        this.logger = LoggerFactory.getLogger((String)Logging.categoryFor(((Object)((Object)this)).getClass(), context));
        this.logger.info("Preparing");
        this.collector = collector;
        if (this.alarmDAO == null) {
            Injector.registerIfNotBound(AlarmDAO.class, (Module[])new Module[]{new PersistenceModule(this.dbConfig)});
            this.alarmDAO = (AlarmDAO)Injector.getInstance(AlarmDAO.class);
        }
        if (this.alarmDefinitionDAO == null) {
            Injector.registerIfNotBound(AlarmDefinitionDAO.class, (Module[])new Module[]{new PersistenceModule(this.dbConfig)});
            this.alarmDefinitionDAO = (AlarmDefinitionDAO)Injector.getInstance(AlarmDefinitionDAO.class);
        }
        if (this.alarmEventForwarder == null) {
            Injector.registerIfNotBound(AlarmEventForwarder.class, (Module[])new Module[]{new ProducerModule(this.producerConfiguration)});
            this.alarmEventForwarder = (AlarmEventForwarder)Injector.getInstance(AlarmEventForwarder.class);
        }
    }

    private void evaluateThreshold(Alarm alarm, SubAlarm subAlarm) {
        this.logger.debug("Received state change for {}", (Object)subAlarm);
        subAlarm.setNoState(false);
        alarm.updateSubAlarm(subAlarm);
        AlarmState initialState = alarm.getState();
        if (this.allSubAlarmsHaveState(alarm) && alarm.evaluate(this.alarmDefinitions.get(alarm.getAlarmDefinitionId()).getAlarmExpression())) {
            this.changeAlarmState(alarm, initialState, alarm.getStateChangeReason());
        }
    }

    private boolean allSubAlarmsHaveState(Alarm alarm) {
        for (SubAlarm subAlarm : alarm.getSubAlarms()) {
            if (!subAlarm.isNoState() || subAlarm.onlyImmediateEvaluation()) continue;
            return false;
        }
        return true;
    }

    private void changeAlarmState(Alarm alarm, AlarmState initialState, String stateChangeReason) {
        AlarmDefinition alarmDefinition = this.alarmDefinitions.get(alarm.getAlarmDefinitionId());
        if (alarmDefinition == null) {
            this.logger.warn("Failed to locate alarm definition for id {}, ignoring state update to alarm with id {}", (Object)alarm.getAlarmDefinitionId(), (Object)alarm.getId());
            return;
        }
        long timestamp = this.getTimestamp();
        this.alarmDAO.updateState(alarm.getId(), alarm.getState(), timestamp);
        ArrayList<MetricDefinition> alarmedMetrics = new ArrayList<MetricDefinition>(alarm.getAlarmedMetrics().size());
        for (MetricDefinitionAndTenantId mdtid : alarm.getAlarmedMetrics()) {
            alarmedMetrics.add(mdtid.metricDefinition);
        }
        this.logger.debug("Alarm {} transitioned from {} to {}", new Object[]{alarm, initialState, alarm.getState()});
        AlarmStateTransitionedEvent event = new AlarmStateTransitionedEvent(alarmDefinition.getTenantId(), alarm.getId(), alarmDefinition.getId(), alarmedMetrics, alarmDefinition.getName(), alarmDefinition.getDescription(), initialState, alarm.getState(), alarmDefinition.getSeverity(), alarm.getLink(), alarm.getLifecycleState(), alarmDefinition.isActionsEnabled(), stateChangeReason, alarm.getTransitionSubAlarms(), timestamp);
        try {
            this.alarmEventForwarder.send(Serialization.toJson((Object)event));
        }
        catch (Exception ignore) {
            this.logger.debug("Failure sending alarm", (Throwable)ignore);
        }
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    void handleAlarmDeleted(String alarmId) {
        this.logger.debug("Received AlarmDeletedEvent for alarm id {}", (Object)alarmId);
        this.alarms.remove(alarmId);
    }

    void handleAlarmUpdated(String alarmId, AlarmUpdatedEvent alarmUpdatedEvent) {
        Alarm oldAlarm = this.alarms.get(alarmId);
        if (oldAlarm == null) {
            this.logger.debug("Updated Alarm {} not loaded, ignoring");
            return;
        }
        oldAlarm.setState(alarmUpdatedEvent.alarmState);
        oldAlarm.setLink(alarmUpdatedEvent.link);
        oldAlarm.setLifecycleState(alarmUpdatedEvent.lifecycleState);
    }

    private Alarm getOrCreateAlarm(String alarmId) {
        Alarm alarm = this.alarms.get(alarmId);
        if (alarm == null) {
            alarm = this.alarmDAO.findById(alarmId);
            if (alarm == null) {
                this.logger.error("Failed to locate alarm for id {}", (Object)alarmId);
                return null;
            }
            if (this.alarmDefinitions.get(alarm.getAlarmDefinitionId()) == null) {
                AlarmDefinition alarmDefinition = this.alarmDefinitionDAO.findById(alarm.getAlarmDefinitionId());
                if (alarmDefinition == null) {
                    this.logger.error("Failed to locate alarm definition for id {}", (Object)alarm.getAlarmDefinitionId());
                    return null;
                }
                this.alarmDefinitions.put(alarmDefinition.getId(), alarmDefinition);
            }
            for (SubAlarm subAlarm : alarm.getSubAlarms()) {
                subAlarm.setNoState(true);
            }
            this.alarms.put(alarmId, alarm);
        }
        return alarm;
    }
}

