/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.event.AlarmDefinitionCreatedEvent;
import monasca.common.model.event.AlarmDefinitionDeletedEvent;
import monasca.common.model.metric.Metric;
import monasca.common.util.Injector;
import monasca.thresh.domain.model.Alarm;
import monasca.thresh.domain.model.AlarmDefinition;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.MetricDefinitionAndTenantIdMatcher;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.model.TenantIdAndMetricName;
import monasca.thresh.domain.service.AlarmDAO;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import monasca.thresh.infrastructure.persistence.PersistenceModule;
import monasca.thresh.infrastructure.thresholding.AlarmCreationBolt;
import monasca.thresh.infrastructure.thresholding.DataSourceFactory;
import monasca.thresh.infrastructure.thresholding.MetricAggregationBolt;
import monasca.thresh.infrastructure.thresholding.PropertyFinder;
import monasca.thresh.utils.Logging;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFilteringBolt
extends BaseRichBolt {
    private static final long serialVersionUID = 1096706128973976599L;
    public static final String NEW_METRIC_FOR_ALARM_DEFINITION_STREAM = "newMetricForAlarmDefinitionStream";
    public static final String[] NEW_METRIC_FOR_ALARM_DEFINITION_FIELDS = new String[]{"metricDefinitionAndTenantId", "alarmDefinitionId"};
    public static final String MIN_LAG_VALUE_KEY = "monasca.thresh.filtering.minLagValue";
    public static final int MIN_LAG_VALUE_DEFAULT = 10;
    public static final String MAX_LAG_MESSAGES_KEY = "monasca.thresh.filtering.maxLagMessages";
    public static final int MAX_LAG_MESSAGES_DEFAULT = 10;
    public static final String LAG_MESSAGE_PERIOD_KEY = "monasca.thresh.filtering.lagMessagePeriod";
    public static final int LAG_MESSAGE_PERIOD_DEFAULT = 30;
    public static final String[] FIELDS = new String[]{"tenantIdAndMetricName", "metric"};
    private static final int MIN_LAG_VALUE = PropertyFinder.getIntProperty("monasca.thresh.filtering.minLagValue", 10, 0, Integer.MAX_VALUE);
    private static final int MAX_LAG_MESSAGES = PropertyFinder.getIntProperty("monasca.thresh.filtering.maxLagMessages", 10, 0, Integer.MAX_VALUE);
    private static final int LAG_MESSAGE_PERIOD = PropertyFinder.getIntProperty("monasca.thresh.filtering.lagMessagePeriod", 30, 1, 600);
    private static final MetricDefinitionAndTenantIdMatcher matcher = new MetricDefinitionAndTenantIdMatcher();
    private static final ExistingHolder alreadyFound = new ExistingHolder();
    private static final Object SENTINAL = new Object();
    private static final Map<String, AlarmDefinition> alarmDefinitions = new ConcurrentHashMap<String, AlarmDefinition>();
    private transient Logger logger;
    private DataSourceFactory dbConfig;
    private transient AlarmDAO alarmDAO;
    private transient AlarmDefinitionDAO alarmDefDAO;
    private OutputCollector collector;
    private long minLag = Long.MAX_VALUE;
    private long lastMinLagMessageSent = 0L;
    private long minLagMessageSent = 0L;
    private boolean lagging = true;

    public MetricFilteringBolt(DataSourceFactory dbConfig) {
        this.dbConfig = dbConfig;
    }

    public MetricFilteringBolt(AlarmDefinitionDAO alarmDefDAO, AlarmDAO alarmDAO) {
        this.alarmDefDAO = alarmDefDAO;
        this.alarmDAO = alarmDAO;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(FIELDS));
        declarer.declareStream(NEW_METRIC_FOR_ALARM_DEFINITION_STREAM, new Fields(NEW_METRIC_FOR_ALARM_DEFINITION_FIELDS));
        declarer.declareStream("MetricAggregationControl", new Fields(MetricAggregationBolt.METRIC_AGGREGATION_CONTROL_FIELDS));
        declarer.declareStream("alarm-creation-stream", new Fields(AlarmCreationBolt.ALARM_CREATION_FIELDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Tuple tuple) {
        block14: {
            this.logger.debug("tuple: {}", (Object)tuple);
            try {
                if ("default".equals(tuple.getSourceStreamId())) {
                    TenantIdAndMetricName timn = (TenantIdAndMetricName)tuple.getValue(0);
                    Long timestamp = (Long)tuple.getValue(1);
                    Metric metric = (Metric)tuple.getValue(2);
                    MetricDefinitionAndTenantId metricDefinitionAndTenantId = new MetricDefinitionAndTenantId(metric.definition(), timn.getTenantId());
                    this.checkLag(timestamp);
                    this.logger.debug("metric definition and tenant id: {}", (Object)metricDefinitionAndTenantId);
                    if (this.checkForMatch(metricDefinitionAndTenantId)) {
                        this.collector.emit((List)new Values(new Object[]{timn, metric}));
                    }
                    break block14;
                }
                String eventType = tuple.getString(0);
                this.logger.debug("Received {} on {}", (Object)eventType, (Object)tuple.getSourceStreamId());
                if ("metric-alarm-events".equals(tuple.getSourceStreamId())) {
                    if ("deleted".equals(eventType)) {
                        this.removeAlarm((MetricDefinitionAndTenantId)tuple.getValue(2), tuple.getString(3));
                    }
                    break block14;
                }
                if (!"alarm-definition-events".equals(tuple.getSourceStreamId())) break block14;
                if ("created".equals(eventType)) {
                    Object timestamp = SENTINAL;
                    synchronized (timestamp) {
                        AlarmDefinitionCreatedEvent event = (AlarmDefinitionCreatedEvent)tuple.getValue(1);
                        AlarmDefinition alarmDefinition = new AlarmDefinition(event.alarmDefinitionId, event.tenantId, event.alarmName, event.alarmDescription, new AlarmExpression(event.alarmExpression), "LOW", true, this.createSubExpressions(event.alarmSubExpressions), event.matchBy);
                        this.newAlarmDefinition(alarmDefinition);
                        break block14;
                    }
                }
                if ("deleted".equals(eventType)) {
                    AlarmDefinitionDeletedEvent event = (AlarmDefinitionDeletedEvent)tuple.getValue(1);
                    this.deleteAlarmDefinition(event.alarmDefinitionId);
                }
            }
            catch (Exception e) {
                this.logger.error("Error processing tuple {}", (Object)tuple, (Object)e);
            }
            finally {
                this.collector.ack(tuple);
            }
        }
    }

    private List<SubExpression> createSubExpressions(Map<String, AlarmSubExpression> alarmSubExpressions) {
        ArrayList<SubExpression> result = new ArrayList<SubExpression>(alarmSubExpressions.size());
        for (Map.Entry<String, AlarmSubExpression> entry : alarmSubExpressions.entrySet()) {
            result.add(new SubExpression(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmDefinition(String alarmDefinitionId) {
        Object object = SENTINAL;
        synchronized (object) {
            AlarmDefinition alarmDefinition = alarmDefinitions.get(alarmDefinitionId);
            if (alarmDefinition != null) {
                this.logger.info("Deleting Alarm Definition {}", (Object)alarmDefinitionId);
                alarmDefinitions.remove(alarmDefinitionId);
                alreadyFound.removeAlarmDefinition(alarmDefinitionId);
                for (MetricDefinitionAndTenantId mtid : this.getAllMetricDefinitions(alarmDefinition)) {
                    matcher.remove(mtid, alarmDefinition.getId());
                }
            }
        }
    }

    private Set<MetricDefinitionAndTenantId> getAllMetricDefinitions(AlarmDefinition alarmDefinition) {
        HashSet<MetricDefinitionAndTenantId> result = new HashSet<MetricDefinitionAndTenantId>(alarmDefinition.getAlarmExpression().getSubExpressions().size());
        for (AlarmSubExpression subExpr : alarmDefinition.getAlarmExpression().getSubExpressions()) {
            MetricDefinitionAndTenantId mtid = new MetricDefinitionAndTenantId(subExpr.getMetricDefinition(), alarmDefinition.getTenantId());
            result.add(mtid);
        }
        return result;
    }

    private void newAlarmDefinition(AlarmDefinition alarmDefinition) {
        alarmDefinitions.put(alarmDefinition.getId(), alarmDefinition);
        for (MetricDefinitionAndTenantId mtid : this.getAllMetricDefinitions(alarmDefinition)) {
            matcher.add(mtid, alarmDefinition.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForMatch(MetricDefinitionAndTenantId metricDefinitionAndTenantId) {
        Set<String> alarmDefinitionIds = matcher.match(metricDefinitionAndTenantId);
        if (alarmDefinitionIds.isEmpty()) {
            return false;
        }
        Set<String> existing = alreadyFound.matches(metricDefinitionAndTenantId);
        if (existing != null) {
            alarmDefinitionIds.removeAll(existing);
        }
        if (!alarmDefinitionIds.isEmpty()) {
            for (String alarmDefinitionId : alarmDefinitionIds) {
                AlarmDefinition alarmDefinition = alarmDefinitions.get(alarmDefinitionId);
                this.logger.info("Add metric {} for Alarm Definition id = {} name = {}", new Object[]{metricDefinitionAndTenantId, alarmDefinitionId, alarmDefinition.getName()});
                this.collector.emit(NEW_METRIC_FOR_ALARM_DEFINITION_STREAM, (List)new Values(new Object[]{metricDefinitionAndTenantId, alarmDefinitionId}));
                Object object = SENTINAL;
                synchronized (object) {
                    alreadyFound.add(metricDefinitionAndTenantId, alarmDefinitionId);
                }
            }
        }
        return true;
    }

    private void checkLag(Long apiTimeStamp) {
        if (!this.lagging) {
            return;
        }
        if (apiTimeStamp == null || apiTimeStamp == 0L) {
            return;
        }
        long now = this.getCurrentTime();
        long lag = now - apiTimeStamp;
        if (lag < this.minLag) {
            this.minLag = lag;
        }
        if (this.minLag <= (long)MIN_LAG_VALUE) {
            this.lagging = false;
            this.logger.info("Metrics no longer lagging, minLag = {}", (Object)this.minLag);
        } else if (this.minLagMessageSent >= (long)MAX_LAG_MESSAGES) {
            this.logger.info("Waited for {} seconds for Metrics to catch up. Giving up. minLag = {}", (Object)(MAX_LAG_MESSAGES * LAG_MESSAGE_PERIOD), (Object)this.minLag);
            this.lagging = false;
        } else if (this.lastMinLagMessageSent == 0L) {
            this.lastMinLagMessageSent = now;
        } else if (now - this.lastMinLagMessageSent >= (long)LAG_MESSAGE_PERIOD) {
            this.logger.info("Sending {} message, minLag = {}", (Object)"MetricsBehind", (Object)this.minLag);
            this.collector.emit("MetricAggregationControl", (List)new Values(new Object[]{"MetricsBehind"}));
            this.lastMinLagMessageSent = now;
            ++this.minLagMessageSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAlarm(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
        AlarmDefinition alarmDefinition = alarmDefinitions.get(alarmDefinitionId);
        if (alarmDefinition != null) {
            Object object = SENTINAL;
            synchronized (object) {
                alreadyFound.remove(metricDefinitionAndTenantId, alarmDefinitionId);
            }
            this.logger.debug("Removed {} for Alarm Definition {}", (Object)metricDefinitionAndTenantId, (Object)alarmDefinitionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.logger = LoggerFactory.getLogger((String)Logging.categoryFor(((Object)((Object)this)).getClass(), context));
        this.logger.info("Preparing");
        this.collector = collector;
        if (this.alarmDefDAO == null) {
            Injector.registerIfNotBound(AlarmDefinitionDAO.class, (Module[])new Module[]{new PersistenceModule(this.dbConfig)});
            this.alarmDefDAO = (AlarmDefinitionDAO)Injector.getInstance(AlarmDefinitionDAO.class);
        }
        if (this.alarmDAO == null) {
            Injector.registerIfNotBound(AlarmDAO.class, (Module[])new Module[]{new PersistenceModule(this.dbConfig)});
            this.alarmDAO = (AlarmDAO)Injector.getInstance(AlarmDAO.class);
        }
        if (alreadyFound.isEmpty()) {
            Object object = SENTINAL;
            synchronized (object) {
                if (alreadyFound.isEmpty()) {
                    for (AlarmDefinition alarmcDef : this.alarmDefDAO.listAll()) {
                        this.newAlarmDefinition(alarmcDef);
                    }
                    for (Alarm alarm : this.alarmDAO.listAll()) {
                        AlarmDefinition alarmDefinition = alarmDefinitions.get(alarm.getAlarmDefinitionId());
                        if (alarmDefinition == null) {
                            this.logger.error("AlarmDefinition {} does not exist for Alarm {}, ignoring", (Object)alarm.getAlarmDefinitionId(), (Object)alarm.getId());
                            continue;
                        }
                        for (MetricDefinitionAndTenantId mtid : alarm.getAlarmedMetrics()) {
                            alreadyFound.add(mtid, alarm.getAlarmDefinitionId());
                            for (SubAlarm subAlarm : alarm.getSubAlarms()) {
                                if (!AlarmCreationBolt.metricFitsInAlarmSubExpr(subAlarm.getExpression(), mtid.metricDefinition)) continue;
                                TenantIdAndMetricName timn = new TenantIdAndMetricName(mtid);
                                Values values = new Values(new Object[]{"created", timn, mtid, alarm.getAlarmDefinitionId(), subAlarm});
                                this.logger.debug("Emitting new SubAlarm {}", (Object)values);
                                collector.emit("alarm-creation-stream", (List)values);
                            }
                        }
                    }
                    this.logger.info("Found {} Alarmed Metrics", (Object)alreadyFound.size());
                    this.logger.info("MIN_LAG_VALUE set to {} seconds", (Object)MIN_LAG_VALUE);
                    this.logger.info("MAX_LAG_MESSAGES set to {}", (Object)MAX_LAG_MESSAGES);
                    this.logger.info("LAG_MESSAGE_PERIOD set to {} seconds", (Object)LAG_MESSAGE_PERIOD);
                }
            }
        }
        this.lastMinLagMessageSent = 0L;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static void clearMetricDefinitions() {
        alreadyFound.clear();
        matcher.clear();
        alarmDefinitions.clear();
    }

    static int sizeMetricDefinitions() {
        return alreadyFound.size();
    }

    private static class ExistingHolder {
        private final Map<MetricDefinitionAndTenantId, Set<String>> metricDefs = new ConcurrentHashMap<MetricDefinitionAndTenantId, Set<String>>();
        private static final Map<String, List<MetricDefinitionAndTenantId>> usedMetrics = new ConcurrentHashMap<String, List<MetricDefinitionAndTenantId>>();

        private ExistingHolder() {
        }

        public void add(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
            Set<String> alarmDefinitionIds = this.metricDefs.get(metricDefinitionAndTenantId);
            if (alarmDefinitionIds == null) {
                alarmDefinitionIds = new HashSet<String>();
                this.metricDefs.put(metricDefinitionAndTenantId, alarmDefinitionIds);
            } else if (alarmDefinitionIds.contains(alarmDefinitionId)) {
                return;
            }
            alarmDefinitionIds.add(alarmDefinitionId);
            List<MetricDefinitionAndTenantId> metrics = usedMetrics.get(alarmDefinitionId);
            if (metrics == null) {
                metrics = new LinkedList<MetricDefinitionAndTenantId>();
                usedMetrics.put(alarmDefinitionId, metrics);
            }
            metrics.add(metricDefinitionAndTenantId);
        }

        public void removeAlarmDefinition(String alarmDefinitionId) {
            List<MetricDefinitionAndTenantId> metrics = usedMetrics.get(alarmDefinitionId);
            if (metrics != null) {
                for (MetricDefinitionAndTenantId mtid : metrics) {
                    this.removeFromMetricDefs(mtid, alarmDefinitionId);
                }
                usedMetrics.remove(alarmDefinitionId);
            }
        }

        public void remove(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
            this.removeFromMetricDefs(metricDefinitionAndTenantId, alarmDefinitionId);
            List<MetricDefinitionAndTenantId> metrics = usedMetrics.get(alarmDefinitionId);
            if (metrics != null && metrics.remove(metricDefinitionAndTenantId) && metrics.isEmpty()) {
                usedMetrics.remove(alarmDefinitionId);
            }
        }

        private void removeFromMetricDefs(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
            Set<String> alarmDefinitionIds = this.matches(metricDefinitionAndTenantId);
            if (alarmDefinitionIds != null && alarmDefinitionIds.remove(alarmDefinitionId) && alarmDefinitionIds.isEmpty()) {
                this.metricDefs.remove(metricDefinitionAndTenantId);
            }
        }

        public Set<String> matches(MetricDefinitionAndTenantId mtid) {
            return this.metricDefs.get(mtid);
        }

        public int size() {
            return this.metricDefs.size();
        }

        public boolean isEmpty() {
            return this.metricDefs.isEmpty();
        }

        public void clear() {
            this.metricDefs.clear();
            usedMetrics.clear();
        }
    }
}

