/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.domain.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.thresh.domain.model.SubExpression;

public class SubAlarm
extends AbstractEntity
implements Serializable {
    private static final long serialVersionUID = -3946708553723868124L;
    private String alarmId;
    private String alarmSubExpressionId;
    private AlarmSubExpression expression;
    private AlarmState state;
    private boolean noState;
    private List<Double> currentValues;

    public SubAlarm(String id, String alarmId, SubExpression expression) {
        this(id, alarmId, expression, SubAlarm.initialStateFromExpression(expression));
    }

    public SubAlarm() {
    }

    public SubAlarm(String id, String alarmId, SubExpression expression, AlarmState state) {
        this.id = id;
        this.alarmId = alarmId;
        this.expression = expression.getAlarmSubExpression();
        this.alarmSubExpressionId = expression.getId();
        this.state = state;
        this.currentValues = new ArrayList<Double>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubAlarm other = (SubAlarm)obj;
        if (this.alarmId == null ? other.alarmId != null : !this.alarmId.equals(other.alarmId)) {
            return false;
        }
        if (this.alarmSubExpressionId == null ? other.alarmSubExpressionId != null : !this.alarmSubExpressionId.equals(other.alarmSubExpressionId)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals((Object)other.expression)) {
            return false;
        }
        return this.state == other.state;
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public AlarmSubExpression getExpression() {
        return this.expression;
    }

    public void setExpression(AlarmSubExpression expression) {
        this.expression = expression;
    }

    public AlarmState getState() {
        return this.state;
    }

    public String getAlarmSubExpressionId() {
        return this.alarmSubExpressionId;
    }

    public List<Double> getCurrentValues() {
        return this.currentValues;
    }

    public void setCurrentValues(List<Double> currentValues) {
        this.currentValues = currentValues;
    }

    public void addCurrentValue(Double currentValue) {
        this.currentValues.add(currentValue);
    }

    public void clearCurrentValues() {
        this.currentValues.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alarmId == null ? 0 : this.alarmId.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.alarmSubExpressionId == null ? 0 : this.alarmSubExpressionId.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean isDeterministic() {
        return this.expression.isDeterministic();
    }

    public void setState(AlarmState state) {
        this.state = state;
    }

    public boolean isNoState() {
        return this.noState;
    }

    public void setNoState(boolean noState) {
        this.noState = noState;
    }

    public String toString() {
        return String.format("SubAlarm [id=%s, alarmId=%s, alarmSubExpressionId=%s, expression=%s, state=%s, noState=%s, currentValues:[", this.id, this.alarmId, this.alarmSubExpressionId, this.expression, this.state, this.noState) + this.currentValues + "]]";
    }

    public boolean isCompatible(AlarmSubExpression other) {
        if (!this.expression.getMetricDefinition().equals((Object)other.getMetricDefinition())) {
            return false;
        }
        if (!this.expression.getFunction().equals((Object)other.getFunction())) {
            return false;
        }
        if (this.expression.getPeriod() != other.getPeriod()) {
            return false;
        }
        return this.expression.getPeriods() == other.getPeriods();
    }

    public boolean canEvaluateAlarmImmediately() {
        switch (this.getExpression().getFunction()) {
            case LAST: {
                return true;
            }
            case MIN: {
                switch (this.getExpression().getOperator()) {
                    case LT: 
                    case LTE: {
                        return true;
                    }
                }
                return false;
            }
            case MAX: 
            case COUNT: {
                switch (this.getExpression().getOperator()) {
                    case GT: 
                    case GTE: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean canEvaluateOkImmediately() {
        switch (this.getExpression().getFunction()) {
            case LAST: {
                return true;
            }
            case MIN: {
                switch (this.getExpression().getOperator()) {
                    case GT: 
                    case GTE: {
                        return true;
                    }
                }
                return false;
            }
            case MAX: 
            case COUNT: {
                switch (this.getExpression().getOperator()) {
                    case LT: 
                    case LTE: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean onlyImmediateEvaluation() {
        switch (this.getExpression().getFunction()) {
            case LAST: {
                return true;
            }
        }
        return false;
    }

    private static AlarmState initialStateFromExpression(SubExpression expr) {
        AlarmSubExpression subExpression = expr.getAlarmSubExpression();
        return SubAlarm.getDefaultState(subExpression.isDeterministic());
    }

    public static AlarmState getDefaultState() {
        return SubAlarm.getDefaultState(false);
    }

    public static AlarmState getDefaultState(boolean deterministic) {
        return deterministic ? AlarmState.OK : AlarmState.UNDETERMINED;
    }
}

