/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.domain.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import monasca.common.model.metric.MetricDefinition;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;

public class MetricDefinitionAndTenantIdMatcher {
    final Map<String, Map<String, List<AlarmDefinitionDimensions>>> byTenantId = new ConcurrentHashMap<String, Map<String, List<AlarmDefinitionDimensions>>>();
    private static final Set<String> EMPTY_SET = Collections.EMPTY_SET;

    public void add(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
        AlarmDefinitionDimensions dimensionSet;
        List<AlarmDefinitionDimensions> alarmDefDimensions;
        Map<String, List<AlarmDefinitionDimensions>> byMetricName = this.byTenantId.get(metricDefinitionAndTenantId.tenantId);
        if (byMetricName == null) {
            byMetricName = new ConcurrentHashMap<String, List<AlarmDefinitionDimensions>>();
            this.byTenantId.put(metricDefinitionAndTenantId.tenantId, byMetricName);
        }
        if ((alarmDefDimensions = byMetricName.get(metricDefinitionAndTenantId.metricDefinition.name)) == null) {
            alarmDefDimensions = new LinkedList<AlarmDefinitionDimensions>();
            byMetricName.put(metricDefinitionAndTenantId.metricDefinition.name, alarmDefDimensions);
        }
        if (!alarmDefDimensions.contains(dimensionSet = this.createDimensionSet(metricDefinitionAndTenantId.metricDefinition, alarmDefinitionId))) {
            alarmDefDimensions.add(dimensionSet);
        }
    }

    private AlarmDefinitionDimensions createDimensionSet(MetricDefinition metricDefinition, String alarmDefinitionId) {
        return new AlarmDefinitionDimensions(metricDefinition.dimensions, alarmDefinitionId);
    }

    public boolean remove(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
        Map<String, List<AlarmDefinitionDimensions>> byMetricName = this.byTenantId.get(metricDefinitionAndTenantId.tenantId);
        if (byMetricName == null) {
            return false;
        }
        List<AlarmDefinitionDimensions> alarmDefDimensions = byMetricName.get(metricDefinitionAndTenantId.metricDefinition.name);
        if (alarmDefDimensions == null) {
            return false;
        }
        AlarmDefinitionDimensions toFind = this.createDimensionSet(metricDefinitionAndTenantId.metricDefinition, alarmDefinitionId);
        boolean result = alarmDefDimensions.remove(toFind);
        if (result && alarmDefDimensions.isEmpty()) {
            byMetricName.remove(metricDefinitionAndTenantId.metricDefinition.name);
            if (byMetricName.isEmpty()) {
                this.byTenantId.remove(metricDefinitionAndTenantId.tenantId);
            }
        }
        return result;
    }

    public Set<String> match(MetricDefinitionAndTenantId toMatch) {
        Map<String, List<AlarmDefinitionDimensions>> byMetricName = this.byTenantId.get(toMatch.tenantId);
        if (byMetricName == null) {
            return EMPTY_SET;
        }
        List<AlarmDefinitionDimensions> alarmDefDimensions = byMetricName.get(toMatch.metricDefinition.name);
        if (alarmDefDimensions == null) {
            return EMPTY_SET;
        }
        HashSet<String> matches = null;
        for (AlarmDefinitionDimensions alarmDefDimension : alarmDefDimensions) {
            if (!alarmDefDimension.isContainedIn(toMatch.metricDefinition.dimensions)) continue;
            if (matches == null) {
                matches = new HashSet<String>();
            }
            matches.add(alarmDefDimension.alarmDefinitionId);
        }
        return matches == null ? EMPTY_SET : matches;
    }

    public boolean isEmpty() {
        return this.byTenantId.isEmpty();
    }

    public void clear() {
        this.byTenantId.clear();
    }

    private static class AlarmDefinitionDimensions {
        final Map<String, String> dimensions;
        final String alarmDefinitionId;

        public AlarmDefinitionDimensions(Map<String, String> dimensions, String alarmDefinitionId) {
            this.dimensions = dimensions != null ? dimensions : new HashMap<String, String>();
            this.alarmDefinitionId = alarmDefinitionId;
        }

        public boolean isContainedIn(Map<String, String> metricDimensions) {
            if (metricDimensions.size() < this.dimensions.size()) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.dimensions.entrySet()) {
                String value = metricDimensions.get(entry.getKey());
                if (!(entry.getValue() == null ? value != null : !entry.getValue().equals(value))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alarmDefinitionId.hashCode();
            result = 31 * result + this.dimensions.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AlarmDefinitionDimensions other = (AlarmDefinitionDimensions)obj;
            if (!this.alarmDefinitionId.equals(other.alarmDefinitionId)) {
                return false;
            }
            return this.dimensions.equals(other.dimensions);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(256);
            builder.append("AlarmDefinitionDimensions [alarmDefinitionId=");
            builder.append(this.alarmDefinitionId);
            builder.append(",dimensions=");
            builder.append(this.dimensions);
            builder.append("]");
            return builder.toString();
        }
    }
}

