/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.persistence;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import monasca.common.hibernate.db.AlarmActionDb;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.hibernate.db.AlarmMetricDb;
import monasca.common.hibernate.db.MetricDefinitionDb;
import monasca.common.hibernate.db.MetricDefinitionDimensionsDb;
import monasca.common.hibernate.db.MetricDimensionDb;
import monasca.common.hibernate.db.NotificationMethodDb;
import monasca.common.hibernate.db.SubAlarmDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDimensionDb;
import monasca.thresh.domain.service.AlarmDAO;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import monasca.thresh.infrastructure.persistence.AlarmDAOImpl;
import monasca.thresh.infrastructure.persistence.AlarmDefinitionDAOImpl;
import monasca.thresh.infrastructure.persistence.hibernate.AlarmDefinitionSqlImpl;
import monasca.thresh.infrastructure.persistence.hibernate.AlarmSqlImpl;
import monasca.thresh.infrastructure.thresholding.DataSourceFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.skife.jdbi.v2.DBI;

public class PersistenceModule
extends AbstractModule {
    private static final String POSTGRES_DS_CLASS = "org.postgresql.ds.PGPoolingDataSource";
    private static final String MYSQL_DS_CLASS = "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
    private final DataSourceFactory dbConfig;

    public PersistenceModule(DataSourceFactory dbConfig) {
        this.dbConfig = dbConfig;
    }

    protected void configure() {
        if (this.dbConfig.isHibernateSupport()) {
            this.bind(AlarmDAO.class).to(AlarmSqlImpl.class).in(Scopes.SINGLETON);
            this.bind(AlarmDefinitionDAO.class).to(AlarmDefinitionSqlImpl.class).in(Scopes.SINGLETON);
        } else {
            this.bind(AlarmDAO.class).to(AlarmDAOImpl.class).in(Scopes.SINGLETON);
            this.bind(AlarmDefinitionDAO.class).to(AlarmDefinitionDAOImpl.class).in(Scopes.SINGLETON);
        }
    }

    @Provides
    @Singleton
    public DBI dbi() throws Exception {
        Class.forName(this.dbConfig.getDriverClass());
        return new DBI(this.dbConfig.getUrl(), this.dbConfig.getUser(), this.dbConfig.getPassword());
    }

    @Provides
    @Singleton
    public SessionFactory sessionFactory() {
        try {
            Configuration configuration = new Configuration();
            configuration.addAnnotatedClass(AlarmDb.class);
            configuration.addAnnotatedClass(AlarmDefinitionDb.class);
            configuration.addAnnotatedClass(AlarmMetricDb.class);
            configuration.addAnnotatedClass(MetricDefinitionDb.class);
            configuration.addAnnotatedClass(MetricDefinitionDimensionsDb.class);
            configuration.addAnnotatedClass(MetricDimensionDb.class);
            configuration.addAnnotatedClass(SubAlarmDefinitionDb.class);
            configuration.addAnnotatedClass(SubAlarmDefinitionDimensionDb.class);
            configuration.addAnnotatedClass(SubAlarmDb.class);
            configuration.addAnnotatedClass(AlarmActionDb.class);
            configuration.addAnnotatedClass(NotificationMethodDb.class);
            configuration.setProperties(this.getHikariProperties(this.dbConfig.getDriverClass()));
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
            return configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        }
        catch (Throwable ex) {
            throw new ProvisionException("Failed to provision Hibernate DB", ex);
        }
    }

    private Properties getHikariProperties(String dataSourceClassName) {
        Properties properties = new Properties();
        switch (dataSourceClassName) {
            case "org.postgresql.ds.PGPoolingDataSource": {
                this.handlePostgresORMProperties(properties);
                break;
            }
            case "com.mysql.jdbc.jdbc2.optional.MysqlDataSource": {
                this.handleMySQLORMProperties(properties);
                break;
            }
            default: {
                throw new ProvisionException(String.format("%s is not supported, valid data sources are %s", dataSourceClassName, Arrays.asList(POSTGRES_DS_CLASS, MYSQL_DS_CLASS)));
            }
        }
        this.handleCommonORMProperties(properties);
        return properties;
    }

    private void handleCommonORMProperties(Properties properties) {
        properties.put("hibernate.connection.provider_class", this.dbConfig.getProviderClass());
        properties.put("hibernate.hbm2ddl.auto", this.dbConfig.getAutoConfig());
        properties.put("show_sql", (Object)false);
        properties.put("hibernate.hikari.dataSource.user", this.dbConfig.getUser());
        properties.put("hibernate.hikari.dataSource.password", this.dbConfig.getPassword());
        properties.put("hibernate.hikari.dataSourceClassName", this.dbConfig.getDriverClass());
        properties.put("hibernate.hikari.connectionTestQuery", this.dbConfig.getValidationQuery());
    }

    private void handleMySQLORMProperties(Properties properties) {
        properties.put("hibernate.hikari.dataSource.url", this.dbConfig.getUrl());
    }

    private void handlePostgresORMProperties(Properties properties) {
        properties.put("hibernate.hikari.dataSource.serverName", this.dbConfig.getServerName());
        properties.put("hibernate.hikari.dataSource.portNumber", this.dbConfig.getPortNumber());
        properties.put("hibernate.hikari.dataSource.databaseName", this.dbConfig.getDatabaseName());
        properties.put("hibernate.hikari.dataSource.initialConnections", this.dbConfig.getMinSize());
        properties.put("hibernate.hikari.dataSource.maxConnections", this.dbConfig.getMaxSize());
        properties.put("hibernate.hikari.connectionTimeout", "5000");
        properties.put("hibernate.hikari.initializationFailFast", "false");
    }
}

