/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.domain.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.thresh.domain.model.SubExpression;

public class AlarmDefinition
extends AbstractEntity {
    private String tenantId;
    private String name;
    private String description;
    private AlarmExpression expression;
    private List<String> matchBy = new ArrayList<String>();
    private boolean actionsEnabled = true;
    private String severity;
    private List<SubExpression> subExpressions = new ArrayList<SubExpression>();

    public AlarmDefinition() {
    }

    public AlarmDefinition(String id, String tenantId, String name, String description, AlarmExpression expression, String severity, boolean actionsEnabled, List<SubExpression> subExpressions, List<String> matchBy) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.expression = expression;
        this.severity = severity;
        this.actionsEnabled = actionsEnabled;
        this.subExpressions = subExpressions;
        this.setMatchBy(matchBy);
    }

    public AlarmDefinition(String tenantId, String name, String description, AlarmExpression expression, String severity, boolean actionsEnabled, List<String> matchBy) {
        this(UUID.randomUUID().toString(), tenantId, name, description, expression, severity, actionsEnabled, new ArrayList<SubExpression>(expression.getSubExpressions().size()), matchBy);
        for (AlarmSubExpression alarmSubExpression : this.expression.getSubExpressions()) {
            this.subExpressions.add(new SubExpression(UUID.randomUUID().toString(), alarmSubExpression));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AlarmDefinition other = (AlarmDefinition)((Object)obj);
        if (!this.compareObjects(this.expression, other.expression)) {
            return false;
        }
        if (!this.compareObjects(this.name, other.name)) {
            return false;
        }
        if (!this.compareObjects(this.severity, other.severity)) {
            return false;
        }
        if (!this.compareObjects(this.description, other.description)) {
            return false;
        }
        if (this.actionsEnabled != other.actionsEnabled) {
            return false;
        }
        if (!this.compareObjects(this.tenantId, other.tenantId)) {
            return false;
        }
        if (!this.compareObjects(this.matchBy, other.matchBy)) {
            return false;
        }
        return this.compareObjects(this.subExpressions, other.subExpressions);
    }

    private boolean compareObjects(Object o1, Object o2) {
        return !(o1 == null ? o2 != null : !o1.equals(o2));
    }

    public AlarmExpression getAlarmExpression() {
        return this.expression;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSeverity() {
        return this.severity;
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.actionsEnabled ? 1783 : 0);
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (this.subExpressions == null ? 0 : this.subExpressions.hashCode());
        result = 31 * result + this.matchBy.hashCode();
        return result;
    }

    public void setExpression(String expression) {
        this.expression = AlarmExpression.of((String)expression);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setActionsEnabled(boolean actionsEnabled) {
        this.actionsEnabled = actionsEnabled;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(91);
        for (String name : this.matchBy) {
            if (builder.length() > 1) {
                builder.append(',');
            }
            builder.append(name);
        }
        builder.append(']');
        return String.format("Alarm [id=%s. tenantId=%s, name=%s, description=%s, expression=%s, severity=%s, actionsEnabled=%s, subExpressions=%s, matchBy=%s]", this.id, this.tenantId, this.name, this.description, this.expression.getExpression(), this.severity, this.actionsEnabled, this.subExpressions, builder);
    }

    public List<String> getMatchBy() {
        return this.matchBy;
    }

    public void setMatchBy(List<String> matchBy) {
        this.matchBy = matchBy == null ? new ArrayList<String>() : matchBy;
    }

    public List<SubExpression> getSubExpressions() {
        return this.subExpressions;
    }

    public void setSubExpressions(List<SubExpression> subExpressions) {
        this.subExpressions = subExpressions;
    }

    public boolean updateSubExpression(String id, AlarmSubExpression alarmSubExpression) {
        for (SubExpression subExpression : this.subExpressions) {
            if (!subExpression.getId().equals(id)) continue;
            subExpression.setAlarmSubExpression(alarmSubExpression);
            return true;
        }
        return false;
    }
}

