/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.utils;

import backtype.storm.metric.api.IMetricsConsumer;
import backtype.storm.task.IErrorReporter;
import backtype.storm.task.TopologyContext;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.timgroup.statsd.NonBlockingUdpSender;
import com.timgroup.statsd.StatsDClientErrorHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import monasca.common.streaming.storm.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdMetricConsumer
implements IMetricsConsumer {
    public static final String STATSD_HOST = "metrics.statsd.host";
    public static final String STATSD_PORT = "metrics.statsd.port";
    public static final String STATSD_PREFIX = "metrics.statsd.prefix";
    public static final String STATSD_DIMENSIONS = "metrics.statsd.dimensions";
    String topologyName;
    String statsdHost = "localhost";
    int statsdPort = 8125;
    String statsdPrefix = "monasca.storm.";
    String monascaStatsdDimPrefix = "|#";
    String defaultDimensions;
    String statsdDimensions = this.defaultDimensions = this.monascaStatsdDimPrefix + "{\"service\":\"monitoring\",\"component\":\"storm\"}";
    transient NonBlockingUdpSender udpclient;
    private transient StatsDClientErrorHandler handler;
    private transient Logger logger;
    StatsDClientErrorHandler statsdErrorHandler = new StatsDClientErrorHandler(){

        public void handle(Exception e) {
            StatsdMetricConsumer.this.logger.error("Error with StatsD UDP client! {}", (Throwable)e);
        }
    };

    public void prepare(Map stormConf, Object registrationArgument, TopologyContext context, IErrorReporter errorReporter) {
        this.logger = LoggerFactory.getLogger((String)Logging.categoryFor(this.getClass(), (TopologyContext)context));
        this.parseConfig(stormConf);
        if (registrationArgument instanceof Map) {
            this.parseConfig((Map)registrationArgument);
        }
        this.initClient();
        this.logger.info("statsdPrefix ({}), topologyName ({}), clean(topologyName) ({})", new Object[]{this.statsdPrefix, this.topologyName, this.clean(this.topologyName)});
    }

    private void initClient() {
        try {
            this.handler = this.statsdErrorHandler;
            this.udpclient = new NonBlockingUdpSender(this.statsdHost, this.statsdPort, Charset.defaultCharset(), this.handler);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("{}", (Throwable)e);
        }
    }

    void parseConfig(Map<?, ?> conf) {
        if (conf.containsKey("topology.name")) {
            this.topologyName = (String)conf.get("topology.name");
        }
        if (conf.containsKey(STATSD_HOST)) {
            this.statsdHost = (String)conf.get(STATSD_HOST);
        }
        if (conf.containsKey(STATSD_PORT)) {
            this.statsdPort = ((Number)conf.get(STATSD_PORT)).intValue();
        }
        if (conf.containsKey(STATSD_PREFIX)) {
            this.statsdPrefix = (String)conf.get(STATSD_PREFIX);
            if (!this.statsdPrefix.endsWith(".")) {
                this.statsdPrefix = this.statsdPrefix + ".";
            }
        }
        if (conf.containsKey(STATSD_DIMENSIONS)) {
            this.statsdDimensions = this.mapToJsonStr((Map)conf.get(STATSD_DIMENSIONS));
            if (!this.isValidJSON(this.statsdDimensions)) {
                this.logger.error("Ignoring dimensions element invalid JSON ({})", new Object[]{this.statsdDimensions});
                this.statsdDimensions = this.monascaStatsdDimPrefix + this.defaultDimensions;
            } else {
                this.statsdDimensions = this.monascaStatsdDimPrefix + this.statsdDimensions;
            }
        }
    }

    private String mapToJsonStr(Map<String, String> inputMap) {
        String results = new String();
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, inputMap);
            results = sw.toString();
        }
        catch (JsonGenerationException e) {
            this.logger.error("{}", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error("{}", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
        return results;
    }

    private boolean isValidJSON(String json) {
        boolean valid = false;
        try {
            JsonParser parser = new ObjectMapper().getFactory().createParser(json);
            while (parser.nextToken() != null) {
            }
            valid = true;
        }
        catch (JsonParseException jpe) {
            valid = false;
        }
        catch (IOException ioe) {
            valid = false;
        }
        return valid;
    }

    String clean(String s) {
        return s.replace('.', '_').replace('/', '_').replace(':', '_').replaceAll("__", "");
    }

    public void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        for (Metric metric : this.dataPointsToMetrics(taskInfo, dataPoints)) {
            this.report(metric.name, metric.value, metric.dimensions);
        }
    }

    private List<Metric> dataPointsToMetrics(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        LinkedList<Metric> res = new LinkedList<Metric>();
        StringBuilder sb = new StringBuilder().append(this.clean(taskInfo.srcComponentId)).append(".");
        int hdrLength = sb.length();
        for (IMetricsConsumer.DataPoint p : dataPoints) {
            sb.delete(hdrLength, sb.length());
            sb.append(this.clean(p.name));
            this.logger.debug("Storm StatsD metric p.name ({}) p.value ({})", new Object[]{p.name, p.value});
            if (p.value instanceof Number) {
                res.add(new Metric(sb.toString(), ((Number)p.value).doubleValue(), this.statsdDimensions));
                continue;
            }
            if (!(p.value instanceof Map) || ((Map)p.value).isEmpty()) continue;
            int hdrAndNameLength = sb.length();
            Map map = (Map)p.value;
            for (Object subName : map.keySet()) {
                Object subValue = map.get(subName);
                if (!(subValue instanceof Number)) continue;
                sb.delete(hdrAndNameLength, sb.length());
                sb.append(".").append(this.clean(subName.toString()));
                res.add(new Metric(sb.toString(), ((Number)subValue).doubleValue(), this.statsdDimensions));
            }
        }
        return res;
    }

    public void report(String s, Double number, String dimensions) {
        if (this.udpclient != null) {
            StringBuilder statsdMessage = new StringBuilder().append(this.statsdPrefix).append(s).append(":").append(String.valueOf(number)).append("|c").append(this.statsdDimensions);
            this.logger.debug("reporting: {}={}{}", new Object[]{s, number, dimensions});
            this.udpclient.send(statsdMessage.toString());
        } else {
            this.initClient();
        }
    }

    public void cleanup() {
        this.udpclient.stop();
    }

    public static class Metric {
        String name;
        Double value;
        String dimensions;

        public Metric(String name, Double value, String dimensions) {
            this.name = name;
            this.value = value;
            this.dimensions = dimensions;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Metric other = (Metric)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value != other.value) {
                return false;
            }
            return this.dimensions.equals(other.dimensions);
        }

        public String toString() {
            return "Metric [name=" + this.name + ", value=" + this.value + ", dimensions=" + this.dimensions + "]";
        }
    }
}

