/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import monasca.common.model.metric.Metric;
import monasca.common.streaming.storm.Logging;
import monasca.common.streaming.storm.Tuples;
import monasca.thresh.ThresholdingConfiguration;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubAlarmStats;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.model.TenantIdAndMetricName;
import monasca.thresh.domain.service.SubAlarmStatsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricAggregationBolt
extends BaseRichBolt {
    private static final long serialVersionUID = 5624314196838090726L;
    public static final String TICK_TUPLE_SECONDS_KEY = "monasca.thresh.aggregation.tick.seconds";
    public static final String[] FIELDS = new String[]{"alarmId", "subAlarm"};
    public static final String METRIC_AGGREGATION_CONTROL_STREAM = "MetricAggregationControl";
    public static final String[] METRIC_AGGREGATION_CONTROL_FIELDS = new String[]{"directive"};
    public static final String METRICS_BEHIND = "MetricsBehind";
    private final ThresholdingConfiguration config;
    final Map<MetricDefinitionAndTenantId, SubAlarmStatsRepository> metricDefToSubAlarmStatsRepos = new HashMap<MetricDefinitionAndTenantId, SubAlarmStatsRepository>();
    private final Set<SubAlarmStats> subAlarmStatsSet = new HashSet<SubAlarmStats>();
    private final Map<String, SubAlarmStats> subAlarmToSubAlarmStats = new HashMap<String, SubAlarmStats>();
    private transient Logger logger;
    private Set<String> sporadicMetricNamespaces = Collections.emptySet();
    private OutputCollector collector;
    private boolean upToDate = true;

    public MetricAggregationBolt(ThresholdingConfiguration config) {
        this.config = config;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(FIELDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Tuple tuple) {
        this.logger.debug("tuple: {}", (Object)tuple);
        try {
            if (Tuples.isTickTuple((Tuple)tuple)) {
                this.evaluateAlarmsAndSlideWindows();
            } else if ("default".equals(tuple.getSourceStreamId())) {
                TenantIdAndMetricName timn = (TenantIdAndMetricName)tuple.getValue(0);
                Metric metric = (Metric)tuple.getValueByField("metric");
                MetricDefinitionAndTenantId metricDefinitionAndTenantId = new MetricDefinitionAndTenantId(metric.definition(), timn.getTenantId());
                this.aggregateValues(metricDefinitionAndTenantId, metric);
            } else if (METRIC_AGGREGATION_CONTROL_STREAM.equals(tuple.getSourceStreamId())) {
                this.processControl(tuple.getString(0));
            } else {
                String eventType = tuple.getString(0);
                if ("metric-alarm-events".equals(tuple.getSourceStreamId())) {
                    MetricDefinitionAndTenantId metricDefinitionAndTenantId = (MetricDefinitionAndTenantId)tuple.getValue(2);
                    String subAlarmId = tuple.getString(4);
                    if ("deleted".equals(eventType)) {
                        this.handleAlarmDeleted(metricDefinitionAndTenantId, subAlarmId);
                    } else if ("resend".equals(eventType)) {
                        this.handleAlarmResend(metricDefinitionAndTenantId, subAlarmId);
                    }
                } else if ("metric-sub-alarm-events".equals(tuple.getSourceStreamId())) {
                    if ("updated".equals(eventType)) {
                        this.handleAlarmSubExpressionUpdated((SubExpression)tuple.getValue(1));
                    }
                } else if ("alarm-creation-stream".equals(tuple.getSourceStreamId())) {
                    MetricDefinitionAndTenantId metricDefinitionAndTenantId = (MetricDefinitionAndTenantId)tuple.getValue(2);
                    SubAlarm subAlarm = (SubAlarm)tuple.getValue(4);
                    if ("created".equals(eventType)) {
                        this.handleAlarmCreated(metricDefinitionAndTenantId, subAlarm);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error processing tuple {}", (Object)tuple, (Object)e);
        }
        finally {
            this.collector.ack(tuple);
        }
    }

    private void processControl(String directive) {
        if (METRICS_BEHIND.equals(directive)) {
            this.logger.debug("Received {}", (Object)directive);
            this.upToDate = false;
        } else {
            this.logger.error("Unknown directive '{}'", (Object)directive);
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.tick.tuple.freq.secs", Integer.valueOf(System.getProperty(TICK_TUPLE_SECONDS_KEY, "60")));
        return conf;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.logger = LoggerFactory.getLogger((String)Logging.categoryFor(((Object)((Object)this)).getClass(), (TopologyContext)context));
        this.logger.info("Preparing");
        this.collector = collector;
    }

    void aggregateValues(MetricDefinitionAndTenantId metricDefinitionAndTenantId, Metric metric) {
        SubAlarmStatsRepository subAlarmStatsRepo = this.getOrCreateSubAlarmStatsRepo(metricDefinitionAndTenantId);
        if (subAlarmStatsRepo == null || metric == null) {
            return;
        }
        for (SubAlarmStats stats : subAlarmStatsRepo.get()) {
            long timestamp_secs = metric.timestamp / 1000L;
            if (stats.getStats().addValue(metric.value, timestamp_secs)) {
                this.logger.trace("Aggregated value {} at {} for {}. Updated {}", new Object[]{metric.value, metric.timestamp, metricDefinitionAndTenantId, stats.getStats()});
                continue;
            }
            this.logger.warn("Metric is too old, age {} seconds: timestamp {} for {}, {}", new Object[]{this.currentTimeSeconds() - timestamp_secs, timestamp_secs, metricDefinitionAndTenantId, stats.getStats()});
        }
    }

    void evaluateAlarmsAndSlideWindows() {
        this.logger.debug("evaluateAlarmsAndSlideWindows called");
        long newWindowTimestamp = this.currentTimeSeconds();
        for (SubAlarmStats subAlarmStats : this.subAlarmStatsSet) {
            if (this.upToDate) {
                this.logger.debug("Evaluating {}", (Object)subAlarmStats);
                if (!subAlarmStats.evaluateAndSlideWindow(newWindowTimestamp, this.config.alarmDelay.intValue())) continue;
                this.logger.debug("Alarm state changed for {}", (Object)subAlarmStats);
                this.collector.emit((List)new Values(new Object[]{subAlarmStats.getSubAlarm().getAlarmId(), subAlarmStats.getSubAlarm()}));
                continue;
            }
            subAlarmStats.slideWindow(newWindowTimestamp, this.config.alarmDelay.intValue());
        }
        if (!this.upToDate) {
            this.logger.info("Did not evaluate SubAlarms because Metrics are not up to date");
            this.upToDate = true;
        }
    }

    protected long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    SubAlarmStatsRepository getOrCreateSubAlarmStatsRepo(MetricDefinitionAndTenantId metricDefinitionAndTenantId) {
        SubAlarmStatsRepository subAlarmStatsRepo = this.metricDefToSubAlarmStatsRepos.get(metricDefinitionAndTenantId);
        if (subAlarmStatsRepo == null) {
            this.logger.debug("Failed to find sub alarms for {}", (Object)metricDefinitionAndTenantId);
        }
        return subAlarmStatsRepo;
    }

    void handleAlarmCreated(MetricDefinitionAndTenantId metricDefinitionAndTenantId, SubAlarm subAlarm) {
        this.logger.info("Received AlarmCreatedEvent for {}", (Object)subAlarm);
        this.addSubAlarm(metricDefinitionAndTenantId, subAlarm);
    }

    void handleAlarmResend(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String subAlarmId) {
        SubAlarmStats oldSubAlarmStats = this.findExistingSubAlarmStats(metricDefinitionAndTenantId, subAlarmId);
        if (oldSubAlarmStats == null) {
            return;
        }
        SubAlarm oldSubAlarm = oldSubAlarmStats.getSubAlarm();
        oldSubAlarm.setNoState(true);
        this.logger.info("Forcing SubAlarm {} to send state at next evaluation", (Object)oldSubAlarm);
    }

    private SubAlarmStats findExistingSubAlarmStats(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String subAlarmId) {
        SubAlarmStatsRepository oldSubAlarmStatsRepo = this.metricDefToSubAlarmStatsRepos.get(metricDefinitionAndTenantId);
        if (oldSubAlarmStatsRepo == null) {
            this.logger.error("Did not find SubAlarmStatsRepository for MetricDefinition {}", (Object)metricDefinitionAndTenantId);
            return null;
        }
        SubAlarmStats oldSubAlarmStats = oldSubAlarmStatsRepo.get(subAlarmId);
        if (oldSubAlarmStats == null) {
            this.logger.error("Did not find existing SubAlarm {} in SubAlarmStatsRepository", (Object)subAlarmId);
            return null;
        }
        return oldSubAlarmStats;
    }

    private void addSubAlarm(MetricDefinitionAndTenantId metricDefinitionAndTenantId, SubAlarm subAlarm) {
        SubAlarmStatsRepository subAlarmStatsRepo;
        SubAlarmStats subAlarmStats = this.subAlarmToSubAlarmStats.get(subAlarm.getId());
        if (subAlarmStats == null) {
            long viewEndTimestamp = this.currentTimeSeconds() + (long)subAlarm.getExpression().getPeriod();
            subAlarmStats = new SubAlarmStats(subAlarm, viewEndTimestamp);
            this.subAlarmToSubAlarmStats.put(subAlarm.getId(), subAlarmStats);
            this.subAlarmStatsSet.add(subAlarmStats);
        }
        if ((subAlarmStatsRepo = this.metricDefToSubAlarmStatsRepos.get(metricDefinitionAndTenantId)) == null) {
            subAlarmStatsRepo = new SubAlarmStatsRepository();
            this.metricDefToSubAlarmStatsRepos.put(metricDefinitionAndTenantId, subAlarmStatsRepo);
        }
        subAlarmStatsRepo.add(subAlarm.getId(), subAlarmStats);
    }

    protected boolean subAlarmRemoved(String subAlarmId, MetricDefinitionAndTenantId metricDefinitionAndTenantId) {
        if (this.subAlarmToSubAlarmStats.containsKey(subAlarmId)) {
            return false;
        }
        SubAlarmStatsRepository subAlarmStatsRepo = this.metricDefToSubAlarmStatsRepos.get(metricDefinitionAndTenantId);
        if (subAlarmStatsRepo != null && this.metricDefToSubAlarmStatsRepos.containsKey(subAlarmId)) {
            return false;
        }
        for (SubAlarmStats subAlarmStats : this.subAlarmStatsSet) {
            if (!subAlarmStats.getSubAlarm().getId().equals(subAlarmId)) continue;
            return false;
        }
        return true;
    }

    void handleAlarmSubExpressionUpdated(SubExpression subExpression) {
        this.logger.debug("Processing SubExpression updated for {}", (Object)subExpression);
        int updated = 0;
        for (SubAlarmStats subAlarmStats : this.subAlarmStatsSet) {
            if (!subAlarmStats.getSubAlarm().getAlarmSubExpressionId().equals(subExpression.getId())) continue;
            long viewEndTimestamp = this.currentTimeSeconds() + (long)subExpression.getAlarmSubExpression().getPeriod();
            subAlarmStats.updateSubAlarm(subExpression.getAlarmSubExpression(), viewEndTimestamp);
            ++updated;
        }
        this.logger.debug("Updated {} SubAlarms", (Object)updated);
    }

    void handleAlarmDeleted(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String subAlarmId) {
        SubAlarmStats subAlarmStats;
        this.logger.debug("Received AlarmDeletedEvent for subAlarm id {}", (Object)subAlarmId);
        SubAlarmStatsRepository subAlarmStatsRepo = this.metricDefToSubAlarmStatsRepos.get(metricDefinitionAndTenantId);
        if (subAlarmStatsRepo != null) {
            subAlarmStatsRepo.remove(subAlarmId);
            if (subAlarmStatsRepo.isEmpty()) {
                this.metricDefToSubAlarmStatsRepos.remove(metricDefinitionAndTenantId);
            }
        }
        if ((subAlarmStats = this.subAlarmToSubAlarmStats.remove(subAlarmId)) != null) {
            this.subAlarmStatsSet.remove(subAlarmStats);
        }
    }
}

