/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import com.google.inject.Module;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.event.AlarmDefinitionDeletedEvent;
import monasca.common.model.event.AlarmDefinitionUpdatedEvent;
import monasca.common.model.event.AlarmDeletedEvent;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.streaming.storm.Logging;
import monasca.common.util.Injector;
import monasca.thresh.domain.model.Alarm;
import monasca.thresh.domain.model.AlarmDefinition;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.model.TenantIdAndMetricName;
import monasca.thresh.domain.service.AlarmDAO;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import monasca.thresh.infrastructure.persistence.PersistenceModule;
import monasca.thresh.infrastructure.thresholding.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmCreationBolt
extends BaseRichBolt {
    private static final long serialVersionUID = 1096706128973976599L;
    public static final String ALARM_CREATION_STREAM = "alarm-creation-stream";
    public static final String[] ALARM_CREATION_FIELDS = new String[]{"control", "tenantIdAndMetricName", "metricDefinitionAndTenantId", "alarmDefinitionId", "subAlarm"};
    private transient Logger logger;
    private DataSourceFactory dbConfig;
    private transient AlarmDefinitionDAO alarmDefDAO;
    private transient AlarmDAO alarmDAO;
    private OutputCollector collector;
    private final Map<String, List<Alarm>> waitingAlarms = new HashMap<String, List<Alarm>>();
    private final Map<String, List<Alarm>> alarmCache = new HashMap<String, List<Alarm>>();
    private final Map<String, AlarmDefinition> alarmDefinitionCache = new HashMap<String, AlarmDefinition>();
    private static final List<Alarm> EMPTY_LIST = Collections.emptyList();

    public AlarmCreationBolt(DataSourceFactory dbConfig) {
        this.dbConfig = dbConfig;
    }

    public AlarmCreationBolt(AlarmDefinitionDAO alarmDefDAO, AlarmDAO alarmDAO) {
        this.alarmDefDAO = alarmDefDAO;
        this.alarmDAO = alarmDAO;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declareStream(ALARM_CREATION_STREAM, new Fields(ALARM_CREATION_FIELDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Tuple tuple) {
        this.logger.debug("tuple: {}", (Object)tuple);
        try {
            if ("newMetricForAlarmDefinitionStream".equals(tuple.getSourceStreamId())) {
                MetricDefinitionAndTenantId metricDefinitionAndTenantId = (MetricDefinitionAndTenantId)tuple.getValue(0);
                this.handleNewMetricDefinition(metricDefinitionAndTenantId, tuple.getString(1));
            } else if ("metric-sub-alarm-events".equals(tuple.getSourceStreamId())) {
                String eventType = tuple.getString(0);
                if ("updated".equals(eventType)) {
                    SubExpression subExpression = (SubExpression)tuple.getValue(1);
                    String alarmDefinitionId = tuple.getString(2);
                    this.updateSubAlarms(subExpression, alarmDefinitionId);
                }
            } else if ("alarm-definition-events".equals(tuple.getSourceStreamId())) {
                String eventType = tuple.getString(0);
                this.logger.debug("Received {} Event", (Object)eventType);
                if ("alarm-definition-events".equals(tuple.getSourceStreamId())) {
                    if ("deleted".equals(eventType)) {
                        AlarmDefinitionDeletedEvent event = (AlarmDefinitionDeletedEvent)tuple.getValue(1);
                        this.deleteAlarmDefinition(event.alarmDefinitionId);
                    } else if ("updated".equals(eventType)) {
                        this.updateAlarmDefinition((AlarmDefinitionUpdatedEvent)tuple.getValue(1));
                    }
                }
            } else if ("alarm-events".equals(tuple.getSourceStreamId())) {
                String eventType = tuple.getString(0);
                if ("deleted".equals(eventType)) {
                    this.removeAlarm((AlarmDeletedEvent)tuple.getValue(2));
                }
            } else {
                this.logger.error("Received tuple on unknown stream {}", (Object)tuple);
            }
        }
        catch (Exception e) {
            this.logger.error("Error processing tuple {}", (Object)tuple, (Object)e);
        }
        finally {
            this.collector.ack(tuple);
        }
    }

    private void removeAlarm(AlarmDeletedEvent event) {
        this.logger.debug("Deleting alarm {} for Alarm Definition {}", (Object)event.alarmId, (Object)event.alarmDefinitionId);
        List<Alarm> alarms = this.alarmCache.get(event.alarmDefinitionId);
        if (alarms != null) {
            for (Alarm alarm : alarms) {
                if (!alarm.getId().equals(event.alarmId)) continue;
                this.logger.debug("Deleted alarm {} for Alarm Definition {}", (Object)event.alarmId, (Object)event.alarmDefinitionId);
                alarms.remove((Object)alarm);
                break;
            }
        }
    }

    private void updateSubAlarms(SubExpression subExpression, String alarmDefinitionId) {
        List<Alarm> waiting;
        this.logger.debug("Updating SubAlarms for AlarmDefinition Id {} SubExpression {}", (Object)alarmDefinitionId, (Object)subExpression);
        int count = 0;
        if (this.alarmDefinitionCache.containsKey(alarmDefinitionId) && (waiting = this.waitingAlarms.get(alarmDefinitionId)) != null && !waiting.isEmpty()) {
            for (Alarm alarm : waiting) {
                if (!alarm.updateSubAlarm(subExpression)) {
                    this.logger.error("Did not find SubAlarms for AlarmDefinition Id {} SubExpression {} Alarm {}", new Object[]{alarmDefinitionId, subExpression, alarm});
                }
                ++count;
            }
        }
        this.logger.debug("Updated {} SubAlarms for AlarmDefinition Id {}", (Object)count, (Object)alarmDefinitionId);
    }

    private void updateAlarmDefinition(AlarmDefinitionUpdatedEvent event) {
        AlarmDefinition alarmDefinition = this.alarmDefinitionCache.get(event.alarmDefinitionId);
        if (alarmDefinition != null) {
            this.logger.debug("Updating AlarmDefinition {}", (Object)event.alarmDefinitionId);
            alarmDefinition.setName(event.alarmName);
            alarmDefinition.setDescription(event.alarmDescription);
            alarmDefinition.setActionsEnabled(event.alarmActionsEnabled);
            alarmDefinition.setExpression(event.alarmExpression);
            alarmDefinition.setSeverity(event.severity);
            if (!alarmDefinition.getMatchBy().equals(event.matchBy)) {
                this.logger.error("AlarmDefinition {}: match-by changed, was {} now {}", new Object[]{event.alarmDefinitionId, alarmDefinition.getMatchBy(), event.matchBy});
            }
            alarmDefinition.setMatchBy(event.matchBy);
            for (Map.Entry entry : event.changedSubExpressions.entrySet()) {
                if (alarmDefinition.updateSubExpression((String)entry.getKey(), (AlarmSubExpression)entry.getValue())) continue;
                this.logger.error("AlarmDefinition {}: Did not finding matching SubAlarmExpression id={} SubAlarmExpression{}", new Object[]{event.alarmDefinitionId, entry.getKey(), entry.getValue()});
            }
        }
    }

    private void deleteAlarmDefinition(String alarmDefinitionId) {
        this.logger.debug("Deleting AlarmDefinition {}", (Object)alarmDefinitionId);
        List<Alarm> waiting = this.waitingAlarms.remove(alarmDefinitionId);
        if (waiting != null && !waiting.isEmpty()) {
            this.logger.debug("{} waiting alarms removed for Alarm Definition Id {}", waiting != null && !waiting.isEmpty() ? Integer.valueOf(waiting.size()) : "No", (Object)alarmDefinitionId);
        }
        this.alarmCache.remove(alarmDefinitionId);
        this.alarmDefinitionCache.remove(alarmDefinitionId);
    }

    protected void handleNewMetricDefinition(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
        long start = System.currentTimeMillis();
        AlarmDefinition alarmDefinition = this.lookUpAlarmDefinition(alarmDefinitionId);
        if (alarmDefinition == null) {
            return;
        }
        if (!this.validMetricDefinition(alarmDefinition, metricDefinitionAndTenantId)) {
            return;
        }
        List<Alarm> existingAlarms = this.getExistingAlarms(alarmDefinitionId);
        if (this.alreadyCreated(existingAlarms, metricDefinitionAndTenantId)) {
            this.logger.warn("MetricDefinition {} is already in existing Alarm", (Object)metricDefinitionAndTenantId);
            return;
        }
        if (this.alreadyCreated(this.getWaitingAlarmsForAlarmDefinition(alarmDefinition), metricDefinitionAndTenantId)) {
            this.logger.warn("MetricDefinition {} is already in waiting Alarm", (Object)metricDefinitionAndTenantId);
            return;
        }
        List<Alarm> matchingAlarms = this.fitsInExistingAlarm(metricDefinitionAndTenantId, alarmDefinition, existingAlarms);
        if (!matchingAlarms.isEmpty()) {
            for (Alarm matchingAlarm : matchingAlarms) {
                this.logger.info("Metric {} fits into existing alarm {}", (Object)metricDefinitionAndTenantId, (Object)matchingAlarm.getId());
                this.addToExistingAlarm(matchingAlarm, metricDefinitionAndTenantId);
                this.sendNewMetricDefinition(matchingAlarm, metricDefinitionAndTenantId);
            }
        } else {
            List<Alarm> newAlarms = this.finishesAlarm(alarmDefinition, metricDefinitionAndTenantId, existingAlarms);
            for (Alarm newAlarm : newAlarms) {
                this.logger.info("Metric {} finishes waiting alarm {}", (Object)metricDefinitionAndTenantId, (Object)newAlarm);
                existingAlarms.add(newAlarm);
                for (MetricDefinitionAndTenantId md : newAlarm.getAlarmedMetrics()) {
                    this.sendNewMetricDefinition(newAlarm, md);
                }
            }
        }
        this.logger.debug("Total processing took {} milliseconds", (Object)(System.currentTimeMillis() - start));
    }

    private List<Alarm> getExistingAlarms(String alarmDefinitionId) {
        List<Alarm> alarms = this.alarmCache.get(alarmDefinitionId);
        if (alarms != null) {
            return alarms;
        }
        long start = System.currentTimeMillis();
        alarms = this.alarmDAO.findForAlarmDefinitionId(alarmDefinitionId);
        this.logger.info("Loading {} Alarms took {} milliseconds", (Object)alarms.size(), (Object)(System.currentTimeMillis() - start));
        this.alarmCache.put(alarmDefinitionId, alarms);
        return alarms;
    }

    private List<Alarm> fitsInExistingAlarm(MetricDefinitionAndTenantId metricDefinitionAndTenantId, AlarmDefinition alarmDefinition, List<Alarm> existingAlarms) {
        LinkedList<Alarm> result = new LinkedList<Alarm>();
        if (alarmDefinition.getMatchBy().isEmpty()) {
            if (!existingAlarms.isEmpty()) {
                result.add(existingAlarms.get(0));
            }
        } else {
            for (Alarm alarm : existingAlarms) {
                if (!this.metricFitsInAlarm(alarm, alarmDefinition, metricDefinitionAndTenantId)) continue;
                result.add(alarm);
            }
        }
        return result;
    }

    private void addToExistingAlarm(Alarm existingAlarm, MetricDefinitionAndTenantId metricDefinitionAndTenantId) {
        existingAlarm.addAlarmedMetric(metricDefinitionAndTenantId);
        long start = System.currentTimeMillis();
        this.alarmDAO.addAlarmedMetric(existingAlarm.getId(), metricDefinitionAndTenantId);
        this.logger.debug("Add Alarm Metric took {} milliseconds", (Object)(System.currentTimeMillis() - start));
    }

    private void sendNewMetricDefinition(Alarm existingAlarm, MetricDefinitionAndTenantId metricDefinitionAndTenantId) {
        for (SubAlarm subAlarm : existingAlarm.getSubAlarms()) {
            if (!AlarmCreationBolt.metricFitsInAlarmSubExpr(subAlarm.getExpression(), metricDefinitionAndTenantId.metricDefinition)) continue;
            TenantIdAndMetricName timn = new TenantIdAndMetricName(metricDefinitionAndTenantId);
            Values values = new Values(new Object[]{"created", timn, metricDefinitionAndTenantId, existingAlarm.getAlarmDefinitionId(), subAlarm});
            this.logger.debug("Emitting new SubAlarm {}", (Object)values);
            this.collector.emit(ALARM_CREATION_STREAM, (List)values);
        }
    }

    public static boolean metricFitsInAlarmSubExpr(AlarmSubExpression subExpr, MetricDefinition check) {
        MetricDefinition md = subExpr.getMetricDefinition();
        if (!md.name.equals(check.name)) {
            return false;
        }
        if (md.dimensions != null && !md.dimensions.isEmpty()) {
            for (Map.Entry entry : md.dimensions.entrySet()) {
                if (((String)entry.getValue()).equals(check.dimensions.get(entry.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validMetricDefinition(AlarmDefinition alarmDefinition, MetricDefinitionAndTenantId check) {
        if (!alarmDefinition.getTenantId().equals(check.tenantId)) {
            return false;
        }
        for (AlarmSubExpression subExpr : alarmDefinition.getAlarmExpression().getSubExpressions()) {
            if (!AlarmCreationBolt.metricFitsInAlarmSubExpr(subExpr, check.metricDefinition)) continue;
            return true;
        }
        return false;
    }

    protected Integer countWaitingAlarms(String alarmDefinitionId) {
        List<Alarm> waiting = this.waitingAlarms.get(alarmDefinitionId);
        return waiting == null ? null : Integer.valueOf(waiting.size());
    }

    private List<Alarm> finishesAlarm(AlarmDefinition alarmDefinition, MetricDefinitionAndTenantId metricDefinitionAndTenantId, List<Alarm> existingAlarms) {
        List<Alarm> waitingAlarms = this.findMatchingWaitingAlarms(this.getWaitingAlarmsForAlarmDefinition(alarmDefinition), alarmDefinition, metricDefinitionAndTenantId);
        LinkedList<Alarm> result = new LinkedList<Alarm>();
        if (waitingAlarms.isEmpty()) {
            Alarm newAlarm = new Alarm(alarmDefinition, AlarmState.UNDETERMINED);
            newAlarm.addAlarmedMetric(metricDefinitionAndTenantId);
            this.reuseExistingMetric(newAlarm, alarmDefinition, existingAlarms);
            if (this.alarmIsComplete(newAlarm)) {
                this.logger.debug("New alarm is complete. Saving");
                this.saveAlarm(newAlarm);
                result.add(newAlarm);
            } else {
                this.logger.debug("Adding new alarm to the waiting list");
                this.addToWaitingAlarms(newAlarm, alarmDefinition);
            }
        } else {
            for (Alarm waiting : waitingAlarms) {
                waiting.addAlarmedMetric(metricDefinitionAndTenantId);
                if (!this.alarmIsComplete(waiting)) continue;
                this.removeFromWaitingAlarms(waiting, alarmDefinition);
                this.saveAlarm(waiting);
                result.add(waiting);
            }
        }
        return result;
    }

    private void reuseExistingMetric(Alarm newAlarm, AlarmDefinition alarmDefinition, List<Alarm> existingAlarms) {
        for (Alarm existingAlarm : existingAlarms) {
            for (MetricDefinitionAndTenantId mtid : existingAlarm.getAlarmedMetrics()) {
                if (!this.metricFitsInAlarm(newAlarm, alarmDefinition, mtid)) continue;
                newAlarm.addAlarmedMetric(mtid);
            }
        }
    }

    private void saveAlarm(Alarm newAlarm) {
        long start = System.currentTimeMillis();
        this.alarmDAO.createAlarm(newAlarm);
        this.logger.debug("Add Alarm took {} milliseconds", (Object)(System.currentTimeMillis() - start));
    }

    private List<Alarm> findMatchingWaitingAlarms(List<Alarm> waiting, AlarmDefinition alarmDefinition, MetricDefinitionAndTenantId check) {
        LinkedList<Alarm> result = new LinkedList<Alarm>();
        for (Alarm alarm : waiting) {
            if (!this.metricFitsInAlarm(alarm, alarmDefinition, check)) continue;
            result.add(alarm);
        }
        return result;
    }

    protected boolean metricFitsInAlarm(Alarm alarm, AlarmDefinition alarmDefinition, MetricDefinitionAndTenantId check) {
        Map<String, String> matchesByValues = this.getMatchesByValues(alarmDefinition, alarm);
        boolean result = false;
        for (SubAlarm subAlarm : alarm.getSubAlarms()) {
            if (!AlarmCreationBolt.metricFitsInAlarmSubExpr(subAlarm.getExpression(), check.metricDefinition)) continue;
            result = true;
            if (matchesByValues.isEmpty()) continue;
            boolean foundOne = false;
            for (Map.Entry<String, String> entry : matchesByValues.entrySet()) {
                String value = (String)check.metricDefinition.dimensions.get(entry.getKey());
                if (value == null) continue;
                if (!value.equals(entry.getValue())) {
                    return false;
                }
                foundOne = true;
            }
            if (foundOne) continue;
            return false;
        }
        return result;
    }

    private Map<String, String> getMatchesByValues(AlarmDefinition alarmDefinition, Alarm alarm) {
        HashMap<String, String> matchesByValues = new HashMap<String, String>();
        if (!alarmDefinition.getMatchBy().isEmpty()) {
            for (MetricDefinitionAndTenantId md : alarm.getAlarmedMetrics()) {
                for (String matchBy : alarmDefinition.getMatchBy()) {
                    String value = (String)md.metricDefinition.dimensions.get(matchBy);
                    if (value == null) continue;
                    matchesByValues.put(matchBy, value);
                }
            }
        }
        return matchesByValues;
    }

    private void removeFromWaitingAlarms(Alarm toRemove, AlarmDefinition alarmDefinition) {
        List<Alarm> waiting = this.waitingAlarms.get(alarmDefinition.getId());
        if (waiting == null || !waiting.remove((Object)toRemove)) {
            this.logger.error("Did not find Alarm to remove");
        }
    }

    private void addToWaitingAlarms(Alarm newAlarm, AlarmDefinition alarmDefinition) {
        List<Alarm> waiting = this.waitingAlarms.get(alarmDefinition.getId());
        if (waiting == null) {
            waiting = new LinkedList<Alarm>();
            this.waitingAlarms.put(alarmDefinition.getId(), waiting);
        }
        waiting.add(newAlarm);
    }

    private List<Alarm> getWaitingAlarmsForAlarmDefinition(AlarmDefinition alarmDefinition) {
        List<Alarm> waiting = this.waitingAlarms.get(alarmDefinition.getId());
        if (waiting == null) {
            return EMPTY_LIST;
        }
        return waiting;
    }

    private boolean alarmIsComplete(Alarm newAlarm) {
        for (SubAlarm subAlarm : newAlarm.getSubAlarms()) {
            boolean found = false;
            for (MetricDefinitionAndTenantId md : newAlarm.getAlarmedMetrics()) {
                if (!AlarmCreationBolt.metricFitsInAlarmSubExpr(subAlarm.getExpression(), md.metricDefinition)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean alreadyCreated(List<Alarm> existingAlarms, MetricDefinitionAndTenantId metricDefinitionAndTenantId) {
        for (Alarm alarm : existingAlarms) {
            for (MetricDefinitionAndTenantId md : alarm.getAlarmedMetrics()) {
                if (!md.equals(metricDefinitionAndTenantId)) continue;
                return true;
            }
        }
        return false;
    }

    private AlarmDefinition lookUpAlarmDefinition(String alarmDefinitionId) {
        AlarmDefinition found = this.alarmDefinitionCache.get(alarmDefinitionId);
        if (found != null) {
            return found;
        }
        found = this.alarmDefDAO.findById(alarmDefinitionId);
        if (found == null) {
            this.logger.warn("Did not find AlarmDefinition for ID {}", (Object)alarmDefinitionId);
            return null;
        }
        this.alarmDefinitionCache.put(found.getId(), found);
        return found;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.logger = LoggerFactory.getLogger((String)Logging.categoryFor(((Object)((Object)this)).getClass(), (TopologyContext)context));
        this.logger.info("Preparing");
        this.collector = collector;
        if (this.alarmDefDAO == null) {
            Injector.registerIfNotBound(AlarmDefinitionDAO.class, (Module[])new Module[]{new PersistenceModule(this.dbConfig)});
            this.alarmDefDAO = (AlarmDefinitionDAO)Injector.getInstance(AlarmDefinitionDAO.class);
        }
        if (this.alarmDAO == null) {
            Injector.registerIfNotBound(AlarmDAO.class, (Module[])new Module[]{new PersistenceModule(this.dbConfig)});
            this.alarmDAO = (AlarmDAO)Injector.getInstance(AlarmDAO.class);
        }
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }
}

