/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.persistence;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import javax.inject.Singleton;
import monasca.thresh.domain.service.AlarmDAO;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import monasca.thresh.infrastructure.persistence.AlarmDAOImpl;
import monasca.thresh.infrastructure.persistence.AlarmDefinitionDAOImpl;
import monasca.thresh.infrastructure.thresholding.DataSourceFactory;
import org.skife.jdbi.v2.DBI;

public class PersistenceModule
extends AbstractModule {
    private final DataSourceFactory dbConfig;

    public PersistenceModule(DataSourceFactory dbConfig) {
        this.dbConfig = dbConfig;
    }

    protected void configure() {
        this.bind(AlarmDAO.class).to(AlarmDAOImpl.class).in(Scopes.SINGLETON);
        this.bind(AlarmDefinitionDAO.class).to(AlarmDefinitionDAOImpl.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public DBI dbi() throws Exception {
        Class.forName(this.dbConfig.getDriverClass());
        return new DBI(this.dbConfig.getUrl(), this.dbConfig.getUser(), this.dbConfig.getPassword());
    }
}

