/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.domain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import monasca.common.model.metric.MetricDefinition;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;

public class MetricDefinitionAndTenantIdMatcher {
    final Map<String, Map<String, Map<DimensionSet, Set<String>>>> byTenantId = new ConcurrentHashMap<String, Map<String, Map<DimensionSet, Set<String>>>>();
    private static final DimensionSet EMPTY_DIMENSION_SET = new DimensionSet(new DimensionPair[0]);
    private static final Set<String> EMPTY_SET = Collections.EMPTY_SET;

    public void add(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
        DimensionSet dimensionSet;
        Set<String> alarmDefIds;
        Map<DimensionSet, Set<String>> byDimensionSet;
        Map<String, Map<DimensionSet, Set<String>>> byMetricName = this.byTenantId.get(metricDefinitionAndTenantId.tenantId);
        if (byMetricName == null) {
            byMetricName = new ConcurrentHashMap<String, Map<DimensionSet, Set<String>>>();
            this.byTenantId.put(metricDefinitionAndTenantId.tenantId, byMetricName);
        }
        if ((byDimensionSet = byMetricName.get(metricDefinitionAndTenantId.metricDefinition.name)) == null) {
            byDimensionSet = new ConcurrentHashMap<DimensionSet, Set<String>>();
            byMetricName.put(metricDefinitionAndTenantId.metricDefinition.name, byDimensionSet);
        }
        if ((alarmDefIds = byDimensionSet.get(dimensionSet = this.createDimensionSet(metricDefinitionAndTenantId.metricDefinition))) == null) {
            alarmDefIds = new HashSet<String>();
            byDimensionSet.put(dimensionSet, alarmDefIds);
        }
        alarmDefIds.add(alarmDefinitionId);
    }

    private DimensionSet createDimensionSet(MetricDefinition metricDefinition) {
        return new DimensionSet(this.createPairs(metricDefinition));
    }

    public boolean remove(MetricDefinitionAndTenantId metricDefinitionAndTenantId, String alarmDefinitionId) {
        Map<String, Map<DimensionSet, Set<String>>> byMetricName = this.byTenantId.get(metricDefinitionAndTenantId.tenantId);
        if (byMetricName == null) {
            return false;
        }
        Map<DimensionSet, Set<String>> byDimensionSet = byMetricName.get(metricDefinitionAndTenantId.metricDefinition.name);
        if (byDimensionSet == null) {
            return false;
        }
        DimensionSet dimensionSet = this.createDimensionSet(metricDefinitionAndTenantId.metricDefinition);
        Set<String> alarmDefinitionIds = byDimensionSet.get(dimensionSet);
        boolean result = false;
        if (alarmDefinitionIds != null && !alarmDefinitionIds.isEmpty() && alarmDefinitionIds.remove(alarmDefinitionId)) {
            result = true;
            if (alarmDefinitionIds.isEmpty()) {
                byDimensionSet.remove(dimensionSet);
                if (byDimensionSet.isEmpty()) {
                    byMetricName.remove(metricDefinitionAndTenantId.metricDefinition.name);
                    if (byMetricName.isEmpty()) {
                        this.byTenantId.remove(metricDefinitionAndTenantId.tenantId);
                    }
                }
            }
        }
        return result;
    }

    public Set<String> match(MetricDefinitionAndTenantId toMatch) {
        Map<String, Map<DimensionSet, Set<String>>> byMetricName = this.byTenantId.get(toMatch.tenantId);
        if (byMetricName == null) {
            return EMPTY_SET;
        }
        Map<DimensionSet, Set<String>> byDimensionSet = byMetricName.get(toMatch.metricDefinition.name);
        if (byDimensionSet == null) {
            return EMPTY_SET;
        }
        DimensionSet[] possibleDimensionSets = this.createPossibleDimensionPairs(toMatch.metricDefinition);
        HashSet<String> matches = null;
        for (DimensionSet dimensionSet : possibleDimensionSets) {
            Set<String> alarmDefinitionIds = byDimensionSet.get(dimensionSet);
            if (alarmDefinitionIds == null) continue;
            if (matches == null) {
                matches = new HashSet<String>();
            }
            matches.addAll(alarmDefinitionIds);
        }
        return matches == null ? EMPTY_SET : matches;
    }

    protected DimensionSet[] createPossibleDimensionPairs(MetricDefinition metricDefinition) {
        int dimensionSize = metricDefinition.dimensions == null ? 0 : metricDefinition.dimensions.size();
        int size = (int)Math.pow(2.0, dimensionSize);
        DimensionSet[] result = new DimensionSet[size];
        int index = 0;
        result[index++] = EMPTY_DIMENSION_SET;
        if (dimensionSize == 0) {
            return result;
        }
        DimensionPair[] pairs = this.createPairs(metricDefinition);
        for (int i = 0; i < pairs.length; ++i) {
            index = this.addMore(pairs, i, EMPTY_DIMENSION_SET, result, index);
        }
        return result;
    }

    private int addMore(DimensionPair[] pairs, int start, DimensionSet dimensionSet, DimensionSet[] result, int index) {
        DimensionPair[] newPairs = new DimensionPair[dimensionSet.pairs.length + 1];
        if (dimensionSet.pairs.length > 0) {
            System.arraycopy(dimensionSet.pairs, 0, newPairs, 0, dimensionSet.pairs.length);
        }
        newPairs[dimensionSet.pairs.length] = pairs[start];
        DimensionSet thisDimensionSet = new DimensionSet(newPairs);
        result[index++] = thisDimensionSet;
        for (int i = start + 1; i < pairs.length; ++i) {
            index = this.addMore(pairs, i, thisDimensionSet, result, index);
        }
        return index;
    }

    private DimensionPair[] createPairs(MetricDefinition metricDefinition) {
        int dimensionSize = metricDefinition.dimensions == null ? 0 : metricDefinition.dimensions.size();
        DimensionPair[] pairs = new DimensionPair[dimensionSize];
        if (dimensionSize > 0) {
            int index = 0;
            for (Map.Entry entry : metricDefinition.dimensions.entrySet()) {
                pairs[index++] = new DimensionPair((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return pairs;
    }

    public boolean isEmpty() {
        return this.byTenantId.isEmpty();
    }

    public void clear() {
        this.byTenantId.clear();
    }

    protected static class DimensionPair
    implements Comparable<DimensionPair> {
        private String key;
        private String value;

        public DimensionPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            int result = 1;
            int prime = 31;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionPair other = (DimensionPair)obj;
            return this.compareStrings(this.key, other.key) && this.compareStrings(this.value, other.value);
        }

        private boolean compareStrings(String s1, String s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1 == null) {
                return false;
            }
            return s1.equals(s2);
        }

        @Override
        public int compareTo(DimensionPair o) {
            int c = this.key.compareTo(o.key);
            if (c != 0) {
                return c;
            }
            if (this.value == null) {
                return o.value == null ? 0 : 1;
            }
            return this.value.compareTo(o.value);
        }

        public String toString() {
            return String.format("DimensionPair %s=%s", this.key, this.value);
        }
    }

    protected static class DimensionSet {
        final DimensionPair[] pairs;

        public DimensionSet(DimensionPair ... pairs) {
            Arrays.sort(pairs);
            this.pairs = pairs;
        }

        public int hashCode() {
            int result = 1;
            int prime = 31;
            for (DimensionPair pair : this.pairs) {
                result = result * 31 + pair.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionSet other = (DimensionSet)obj;
            if (this.pairs.length != other.pairs.length) {
                return false;
            }
            for (int i = 0; i < this.pairs.length; ++i) {
                if (this.pairs[i].equals(other.pairs[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(256);
            builder.append("DimensionSet [");
            boolean first = true;
            for (DimensionPair pair : this.pairs) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(pair.toString());
                first = false;
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

