/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.domain.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.alarm.AlarmTransitionSubAlarm;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.thresh.domain.model.AlarmDefinition;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;

public class Alarm
extends AbstractEntity {
    private Map<String, SubAlarm> subAlarms;
    private Set<MetricDefinitionAndTenantId> alarmedMetrics = new HashSet<MetricDefinitionAndTenantId>();
    private AlarmState state;
    private String stateChangeReason;
    private String alarmDefinitionId;
    private List<AlarmTransitionSubAlarm> transitionSubAlarms = new ArrayList<AlarmTransitionSubAlarm>();

    public Alarm() {
    }

    public Alarm(AlarmDefinition alarmDefinition, AlarmState state) {
        this.id = UUID.randomUUID().toString();
        List<SubExpression> subExpressions = alarmDefinition.getSubExpressions();
        ArrayList<SubAlarm> subAlarms = new ArrayList<SubAlarm>(subExpressions.size());
        for (SubExpression subExpr : subExpressions) {
            subAlarms.add(new SubAlarm(UUID.randomUUID().toString(), this.id, subExpr));
        }
        this.setSubAlarms(subAlarms);
        this.state = state;
        this.alarmDefinitionId = alarmDefinition.getId();
    }

    public String buildStateChangeReason(AlarmState alarmState) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AlarmTransitionSubAlarm alarmTransitionSubAlarm : this.transitionSubAlarms) {
            if (!alarmTransitionSubAlarm.subAlarmState.equals((Object)alarmState)) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(alarmTransitionSubAlarm.subAlarmExpression);
            if (AlarmState.UNDETERMINED.equals((Object)alarmState)) continue;
            stringBuilder.append(" with the values: ").append(alarmTransitionSubAlarm.currentValues);
        }
        if (AlarmState.UNDETERMINED.equals((Object)alarmState)) {
            return String.format("No data was present for the sub-alarms: %s", stringBuilder.toString());
        }
        if (AlarmState.ALARM.equals((Object)alarmState)) {
            return String.format("Thresholds were exceeded for the sub-alarms: %s", stringBuilder.toString());
        }
        return String.format("The alarm threshold(s) have not been exceeded for the sub-alarms: %s", stringBuilder.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Alarm other = (Alarm)((Object)obj);
        if (this.state != other.state) {
            return false;
        }
        if (!this.compareObjects(this.alarmDefinitionId, other.alarmDefinitionId)) {
            return false;
        }
        if (!this.compareObjects(this.subAlarms, other.subAlarms)) {
            return false;
        }
        if (!this.compareObjects(this.stateChangeReason, other.stateChangeReason)) {
            return false;
        }
        return this.compareObjects(this.alarmedMetrics, other.alarmedMetrics);
    }

    private boolean compareObjects(Object o1, Object o2) {
        return !(o1 == null ? o2 != null : !o1.equals(o2));
    }

    public boolean evaluate(AlarmExpression expression) {
        this.transitionSubAlarms.clear();
        AlarmState initialState = this.state;
        boolean uninitialized = false;
        for (SubAlarm subAlarm : this.subAlarms.values()) {
            if (AlarmState.UNDETERMINED.equals((Object)subAlarm.getState())) {
                uninitialized = true;
            }
            this.transitionSubAlarms.add(new AlarmTransitionSubAlarm(subAlarm.getExpression(), subAlarm.getState(), subAlarm.getCurrentValues()));
        }
        if (uninitialized) {
            if (AlarmState.UNDETERMINED.equals((Object)initialState)) {
                return false;
            }
            this.state = AlarmState.UNDETERMINED;
            this.stateChangeReason = this.buildStateChangeReason(this.state);
            return true;
        }
        HashMap<AlarmSubExpression, Boolean> subExpressionValues = new HashMap<AlarmSubExpression, Boolean>();
        for (SubAlarm subAlarm : this.subAlarms.values()) {
            subExpressionValues.put(subAlarm.getExpression(), AlarmState.ALARM.equals((Object)subAlarm.getState()));
        }
        if (expression.evaluate(subExpressionValues)) {
            if (AlarmState.ALARM.equals((Object)initialState)) {
                return false;
            }
            this.state = AlarmState.ALARM;
            this.stateChangeReason = this.buildStateChangeReason(this.state);
            return true;
        }
        if (AlarmState.OK.equals((Object)initialState)) {
            return false;
        }
        this.state = AlarmState.OK;
        this.stateChangeReason = this.buildStateChangeReason(this.state);
        return true;
    }

    public AlarmState getState() {
        return this.state;
    }

    public String getStateChangeReason() {
        return this.stateChangeReason;
    }

    public Collection<SubAlarm> getSubAlarms() {
        return this.subAlarms.values();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.subAlarms == null ? 0 : this.subAlarms.hashCode());
        result = 31 * result + (this.alarmDefinitionId == null ? 0 : this.alarmDefinitionId.hashCode());
        result = 31 * result + (this.stateChangeReason == null ? 0 : this.stateChangeReason.hashCode());
        result = 31 * result + (this.alarmedMetrics == null ? 0 : this.alarmedMetrics.hashCode());
        return result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setState(AlarmState state) {
        this.state = state;
    }

    public void setSubAlarms(List<SubAlarm> subAlarms) {
        this.subAlarms = new HashMap<String, SubAlarm>();
        for (SubAlarm subAlarm : subAlarms) {
            this.subAlarms.put(subAlarm.getId(), subAlarm);
        }
    }

    public boolean updateSubAlarm(SubExpression subExpression) {
        for (SubAlarm subAlarm : this.subAlarms.values()) {
            if (!subAlarm.getAlarmSubExpressionId().equals(subExpression.getId())) continue;
            subAlarm.setExpression(subExpression.getAlarmSubExpression());
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder alarmedMetricsString = new StringBuilder();
        for (MetricDefinitionAndTenantId md : this.alarmedMetrics) {
            if (alarmedMetricsString.length() > 0) {
                alarmedMetricsString.append(',');
            }
            alarmedMetricsString.append(md.toString());
        }
        return String.format("Alarm [id=%s, state=%s, alarmDefinitionid=%s, alarmedMetrics=[%s]]", this.getId(), this.state, this.alarmDefinitionId, alarmedMetricsString);
    }

    public void updateSubAlarm(SubAlarm subAlarm) {
        this.subAlarms.put(subAlarm.getId(), subAlarm);
    }

    public boolean removeSubAlarmById(String toDeleteId) {
        return this.subAlarms.remove(toDeleteId) != null;
    }

    public String getAlarmDefinitionId() {
        return this.alarmDefinitionId;
    }

    public void setAlarmDefinitionId(String alarmDefinitionId) {
        this.alarmDefinitionId = alarmDefinitionId;
    }

    public Set<MetricDefinitionAndTenantId> getAlarmedMetrics() {
        return this.alarmedMetrics;
    }

    public void setAlarmedMetrics(Set<MetricDefinitionAndTenantId> alarmedMetrics) {
        this.alarmedMetrics = alarmedMetrics;
    }

    public void addAlarmedMetric(MetricDefinitionAndTenantId alarmedMetric) {
        this.alarmedMetrics.add(alarmedMetric);
    }

    public List<AlarmTransitionSubAlarm> getTransitionSubAlarms() {
        return this.transitionSubAlarms;
    }

    public void setTransitionSubAlarms(List<AlarmTransitionSubAlarm> transitionSubAlarms) {
        this.transitionSubAlarms = transitionSubAlarms;
    }
}

