/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.ExecutorService;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.pipeline.ManagedPipeline;
import monasca.persister.repository.RepoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerRunnableBasic<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerRunnableBasic.class);
    private final KafkaChannel kafkaChannel;
    private final String threadId;
    private final ManagedPipeline<T> pipeline;
    private volatile boolean stop = false;
    private ExecutorService executorService;

    @Inject
    public KafkaConsumerRunnableBasic(@Assisted KafkaChannel kafkaChannel, @Assisted ManagedPipeline<T> pipeline, @Assisted String threadId) {
        this.kafkaChannel = kafkaChannel;
        this.pipeline = pipeline;
        this.threadId = threadId;
    }

    public KafkaConsumerRunnableBasic<T> setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    protected void publishHeartbeat() throws RepoException {
        this.publishEvent(null);
    }

    private void markRead() {
        logger.debug("[{}]: marking read", (Object)this.threadId);
        this.kafkaChannel.markRead();
    }

    public void stop() {
        logger.info("[{}]: stop", (Object)this.threadId);
        this.stop = true;
    }

    @Override
    public void run() {
        logger.info("[{}]: run", (Object)this.threadId);
        ConsumerIterator it = this.kafkaChannel.getKafkaStream().iterator();
        logger.debug("[{}]: KafkaChannel has stream iterator", (Object)this.threadId);
        while (!this.stop) {
            try {
                try {
                    if (this.isInterrupted()) {
                        logger.debug("[{}]: is interrupted", (Object)this.threadId);
                        break;
                    }
                    if (!it.hasNext()) continue;
                    if (this.isInterrupted()) {
                        logger.debug("[{}]: is interrupted", (Object)this.threadId);
                        break;
                    }
                    if (this.stop) {
                        logger.debug("[{}]: is stopped", (Object)this.threadId);
                        break;
                    }
                    String msg = new String((byte[])it.next().message());
                    logger.debug("[{}]: {}", (Object)this.threadId, (Object)msg);
                    this.publishEvent(msg);
                }
                catch (ConsumerTimeoutException cte) {
                    if (this.isInterrupted()) {
                        logger.debug("[{}]: is interrupted", (Object)this.threadId);
                        break;
                    }
                    if (this.stop) {
                        logger.debug("[{}]: is stopped", (Object)this.threadId);
                        break;
                    }
                    this.publishHeartbeat();
                }
            }
            catch (Throwable e) {
                logger.error("[{}]: caught fatal exception while publishing msg. Shutting entire persister down now!", (Object)this.threadId, (Object)e);
                logger.error("[{}]: calling shutdown on executor service", (Object)this.threadId);
                this.executorService.shutdownNow();
                logger.error("[{}]: shutting down system. calling system.exit(1)", (Object)this.threadId);
                System.exit(1);
            }
        }
        logger.info("[{}]: calling stop on kafka channel", (Object)this.threadId);
        this.kafkaChannel.stop();
        logger.debug("[{}]: exiting main run loop", (Object)this.threadId);
    }

    protected void publishEvent(String msg) throws RepoException {
        if (this.pipeline.publishEvent(msg)) {
            this.markRead();
        }
    }

    private boolean isInterrupted() {
        Thread.currentThread();
        if (Thread.interrupted()) {
            logger.debug("[{}]: is interrupted. breaking out of run loop", (Object)this.threadId);
            return true;
        }
        return false;
    }
}

