/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.ExecutorService;
import monasca.persister.consumer.KafkaConsumerRunnableBasic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer<T> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumer.class);
    private ExecutorService executorService;
    private final KafkaConsumerRunnableBasic<T> kafkaConsumerRunnableBasic;
    private final String threadId;

    @Inject
    public KafkaConsumer(@Assisted KafkaConsumerRunnableBasic<T> kafkaConsumerRunnableBasic, @Assisted String threadId, @Assisted ExecutorService executorService) {
        this.kafkaConsumerRunnableBasic = kafkaConsumerRunnableBasic;
        this.threadId = threadId;
        this.executorService = executorService;
    }

    public void start() {
        logger.info("[{}]: start", (Object)this.threadId);
        this.executorService.submit(this.kafkaConsumerRunnableBasic.setExecutorService(this.executorService));
    }

    public void stop() {
        logger.info("[{}]: stop", (Object)this.threadId);
        this.kafkaConsumerRunnableBasic.stop();
    }
}

