/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.vertica;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.dropwizard.setup.Environment;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.inject.Inject;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.configuration.PersisterConfig;
import monasca.persister.repository.Repo;
import monasca.persister.repository.RepoException;
import monasca.persister.repository.vertica.VerticaRepo;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticaAlarmRepo
extends VerticaRepo
implements Repo<AlarmStateTransitionedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(VerticaAlarmRepo.class);
    private final Environment environment;
    private static final String SQL_INSERT_INTO_ALARM_HISTORY = "insert into MonAlarms.StateHistory (tenant_id, alarm_id, metrics, old_state, new_state, sub_alarms, reason, reason_data, time_stamp) values (:tenant_id, :alarm_id, :metrics, :old_state, :new_state, :sub_alarms, :reason, :reason_data, :time_stamp)";
    private static final int MAX_BYTES_PER_CHAR = 4;
    private static final int MAX_LENGTH_VARCHAR = 65000;
    private PreparedBatch batch;
    private final Timer commitTimer;
    private final SimpleDateFormat simpleDateFormat;
    private int msgCnt = 0;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public VerticaAlarmRepo(DBI dbi, PersisterConfig configuration, Environment environment) throws NoSuchAlgorithmException, SQLException {
        super(dbi);
        logger.debug("Instantiating " + this.getClass().getName());
        this.environment = environment;
        this.commitTimer = this.environment.metrics().timer(this.getClass().getName() + ".commit-timer");
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        logger.debug("preparing batches...");
        this.handle.getConnection().setAutoCommit(false);
        this.batch = this.handle.prepareBatch(SQL_INSERT_INTO_ALARM_HISTORY);
        this.handle.begin();
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0"));
        logger.debug(this.getClass().getName() + " is fully instantiated");
    }

    @Override
    public void addToBatch(AlarmStateTransitionedEvent message, String id) {
        String subAlarmsString;
        String metricsString = this.getSerializedString(message.metrics, id);
        if (metricsString.length() * 4 >= 65000) {
            metricsString = "[]";
            logger.warn("length of metricsString for alarm ID {} exceeds max length of {}", (Object)message.alarmId, (Object)65000);
        }
        if ((subAlarmsString = this.getSerializedString(message.subAlarms, id)).length() * 4 >= 65000) {
            subAlarmsString = "[]";
            logger.warn("length of subAlarmsString for alarm ID {} exceeds max length of {}", (Object)message.alarmId, (Object)65000);
        }
        String timeStamp = this.simpleDateFormat.format(new Date(message.timestamp));
        ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)this.batch.add().bind("tenant_id", message.tenantId)).bind("alarm_id", message.alarmId)).bind("metrics", metricsString)).bind("old_state", message.oldState.name())).bind("new_state", message.newState.name())).bind("sub_alarms", subAlarmsString)).bind("reason", message.stateChangeReason)).bind("reason_data", "{}")).bind("time_stamp", timeStamp);
        ++this.msgCnt;
    }

    private String getSerializedString(Object o, String id) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.error("[[}]: failed to serialize object {}", new Object[]{id, o, e});
            return "";
        }
    }

    @Override
    public int flush(String id) throws RepoException {
        try {
            this.commitBatch(id);
            int commitCnt = this.msgCnt;
            this.msgCnt = 0;
            return commitCnt;
        }
        catch (Exception e) {
            logger.error("[{}]: failed to write alarms to vertica", (Object)id, (Object)e);
            throw new RepoException("failed to commit batch to vertica", e);
        }
    }

    private void commitBatch(String id) {
        long startTime = System.currentTimeMillis();
        Timer.Context context = this.commitTimer.time();
        this.batch.execute();
        this.handle.commit();
        this.handle.begin();
        context.stop();
        long endTime = System.currentTimeMillis();
        logger.debug("[{}]: committing batch took {} ms", (Object)id, (Object)(endTime - startTime));
    }
}

