/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline.event;

import com.codahale.metrics.Counter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.configuration.PipelineConfig;
import monasca.persister.pipeline.event.FlushableHandler;
import monasca.persister.repository.Repo;
import monasca.persister.repository.RepoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStateTransitionHandler
extends FlushableHandler<AlarmStateTransitionedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AlarmStateTransitionHandler.class);
    private final Repo<AlarmStateTransitionedEvent> alarmRepo;
    private final Counter alarmStateTransitionCounter;

    @Inject
    public AlarmStateTransitionHandler(Repo<AlarmStateTransitionedEvent> alarmRepo, Environment environment, @Assisted PipelineConfig configuration, @Assisted(value="threadId") String threadId, @Assisted(value="batchSize") int batchSize) {
        super(configuration, environment, threadId, batchSize);
        this.alarmRepo = alarmRepo;
        this.alarmStateTransitionCounter = environment.metrics().counter(this.handlerName + "." + "alarm-state-transitions-added-to-batch-counter");
    }

    @Override
    protected int process(String msg) {
        AlarmStateTransitionedEvent alarmStateTransitionedEvent;
        try {
            alarmStateTransitionedEvent = (AlarmStateTransitionedEvent)this.objectMapper.readValue(msg, AlarmStateTransitionedEvent.class);
        }
        catch (IOException e) {
            logger.error("[{}]: failed to deserialize message {}", new Object[]{this.threadId, msg, e});
            return 0;
        }
        logger.debug("[{}]: [{}:{}] {}", new Object[]{this.threadId, this.getBatchCount(), this.getMsgCount(), alarmStateTransitionedEvent});
        this.alarmRepo.addToBatch(alarmStateTransitionedEvent, this.threadId);
        this.alarmStateTransitionCounter.inc();
        return 1;
    }

    @Override
    protected void initObjectMapper() {
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    @Override
    protected int flushRepository() throws RepoException {
        return this.alarmRepo.flush(this.threadId);
    }
}

